/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.CoreSamlMetadataProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataExpirationPolicy;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.criterion.SatisfyAnyCriterion;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceDefaultCachingMetadataResolver
implements SamlRegisteredServiceCachingMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceDefaultCachingMetadataResolver.class);
    @Generated
    private final Object $lock = new Object[0];
    private final CacheLoader<SamlRegisteredServiceCacheKey, MetadataResolver> chainingMetadataResolverCacheLoader;
    private final LoadingCache<SamlRegisteredServiceCacheKey, MetadataResolver> cache;
    private final OpenSamlConfigBean openSamlConfigBean;

    public SamlRegisteredServiceDefaultCachingMetadataResolver(CasConfigurationProperties casProperties, CacheLoader<SamlRegisteredServiceCacheKey, MetadataResolver> loader, OpenSamlConfigBean openSamlConfigBean) {
        this.openSamlConfigBean = openSamlConfigBean;
        this.chainingMetadataResolverCacheLoader = loader;
        CoreSamlMetadataProperties core = casProperties.getAuthn().getSamlIdp().getMetadata().getCore();
        Duration metadataCacheExpiration = Beans.newDuration((String)core.getCacheExpiration());
        this.cache = Caffeine.newBuilder().maximumSize(core.getCacheMaximumSize()).recordStats().expireAfter((Expiry)new SamlRegisteredServiceMetadataExpirationPolicy(metadataCacheExpiration)).build(this.chainingMetadataResolverCacheLoader);
    }

    private static long countResolvableEntityDescriptors(MetadataResolutionResult result) {
        return ((Integer)FunctionUtils.doUnchecked(() -> {
            EvaluableEntityRoleEntityDescriptorCriterion criteria = new EvaluableEntityRoleEntityDescriptorCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            return Iterables.size((Iterable)result.getMetadataResolver().resolve((Object)new CriteriaSet(new Criterion[]{criteria})));
        })).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataResolver resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        Object object = this.$lock;
        synchronized (object) {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            LOGGER.debug("Resolving metadata for [{}] at [{}]", (Object)service.getName(), (Object)metadataLocation);
            SamlRegisteredServiceCacheKey cacheKey = new SamlRegisteredServiceCacheKey(service, criteriaSet);
            LOGGER.trace("Locating cached metadata resolver using key [{}] for service [{}]", (Object)cacheKey.getId(), (Object)service.getName());
            return (MetadataResolver)FunctionUtils.doAndRetry(retryContext -> {
                MetadataResolverCacheQueryResult queryResult = this.locateAndCacheMetadataResolver(service, criteriaSet, cacheKey);
                MetadataResolutionResult result = this.isMetadataResolverAcceptable(queryResult, criteriaSet);
                if (!result.isValid()) {
                    long count = SamlRegisteredServiceDefaultCachingMetadataResolver.countResolvableEntityDescriptors(result);
                    if (count == 1L) {
                        this.invalidate(service, criteriaSet);
                    }
                    LOGGER.warn("SAML metadata resolver [{}] obtained from the cache is unable to produce/resolve valid metadata from [{}]. Metadata resolver cache entry with key [{}] has been invalidated. Retry attempt: [{}]", new Object[]{result.getMetadataResolver().getId(), metadataLocation, cacheKey.getId(), retryContext.getRetryCount()});
                    throw new SamlException("Unable to locate a valid SAML metadata resolver for " + metadataLocation + " to locate " + criteriaSet);
                }
                return queryResult.getMetadataResolver();
            });
        }
    }

    public void invalidate() {
        LOGGER.trace("Invalidating cache, removing all metadata resolvers");
        this.cache.invalidateAll();
    }

    public void invalidate(SamlRegisteredService service, CriteriaSet criteriaSet) {
        LOGGER.trace("Invalidating cache for [{}].", (Object)service.getName());
        SamlRegisteredServiceCacheKey cacheKey = new SamlRegisteredServiceCacheKey(service, criteriaSet);
        this.cache.invalidate((Object)cacheKey);
    }

    protected MetadataResolutionResult isMetadataResolverAcceptable(MetadataResolverCacheQueryResult queryResult, CriteriaSet criteriaSet) {
        if (criteriaSet.contains(SatisfyAnyCriterion.class)) {
            return ((MetadataResolutionResult.MetadataResolutionResultBuilder)((MetadataResolutionResult.MetadataResolutionResultBuilder)MetadataResolutionResult.builder().entityDescriptor(Optional.empty())).valid(true)).build();
        }
        EntityDescriptor md = queryResult.getEntityDescriptor().orElseGet(Unchecked.supplier(() -> (EntityDescriptor)queryResult.getMetadataResolver().resolveSingle((Object)criteriaSet)));
        return ((MetadataResolutionResult.MetadataResolutionResultBuilder)((MetadataResolutionResult.MetadataResolutionResultBuilder)((MetadataResolutionResult.MetadataResolutionResultBuilder)MetadataResolutionResult.builder().valid(md != null && md.isValid())).entityDescriptor(Optional.ofNullable(md))).metadataResolver(queryResult.getMetadataResolver())).build();
    }

    protected MetadataResolverCacheQueryResult locateAndCacheMetadataResolver(SamlRegisteredService service, CriteriaSet criteriaSet, SamlRegisteredServiceCacheKey cacheKey) {
        Optional result = this.cache.asMap().values().stream().map(Unchecked.function(r -> {
            EntityDescriptor entity = (EntityDescriptor)r.resolveSingle((Object)criteriaSet);
            return Optional.ofNullable(entity).map(e -> ((MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder)((MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder)MetadataResolverCacheQueryResult.builder().metadataResolver((MetadataResolver)r)).entityDescriptor(Optional.of(e))).build());
        })).filter(Optional::isPresent).flatMap(Optional::stream).findFirst();
        if (result.isPresent()) {
            return (MetadataResolverCacheQueryResult)result.get();
        }
        LOGGER.debug("Loading metadata resolver from the cache using [{}]", (Object)cacheKey.getCacheKey());
        MetadataResolver resolver = Objects.requireNonNull((MetadataResolver)this.cache.get((Object)cacheKey));
        LOGGER.debug("Loaded and cached SAML metadata [{}] from [{}]", (Object)resolver.getId(), (Object)service.getMetadataLocation());
        return ((MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder)((MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder)MetadataResolverCacheQueryResult.builder().entityDescriptor(Optional.empty())).metadataResolver(resolver)).build();
    }

    Optional<MetadataResolver> resolveIfPresent(SamlRegisteredService service, CriteriaSet criteriaSet) {
        SamlRegisteredServiceCacheKey cacheKey = new SamlRegisteredServiceCacheKey(service, criteriaSet);
        return Optional.ofNullable((MetadataResolver)this.cache.getIfPresent((Object)cacheKey));
    }

    CacheStats getCacheStatistics() {
        return this.cache.stats();
    }

    @Generated
    public OpenSamlConfigBean getOpenSamlConfigBean() {
        return this.openSamlConfigBean;
    }

    private static class MetadataResolverCacheQueryResult {
        private final MetadataResolver metadataResolver;
        private final Optional<EntityDescriptor> entityDescriptor;

        @Generated
        private static Optional<EntityDescriptor> $default$entityDescriptor() {
            return Optional.empty();
        }

        @Generated
        protected MetadataResolverCacheQueryResult(MetadataResolverCacheQueryResultBuilder<?, ?> b) {
            this.metadataResolver = b.metadataResolver;
            this.entityDescriptor = b.entityDescriptor$set ? b.entityDescriptor$value : MetadataResolverCacheQueryResult.$default$entityDescriptor();
        }

        @Generated
        public static MetadataResolverCacheQueryResultBuilder<?, ?> builder() {
            return new MetadataResolverCacheQueryResultBuilderImpl();
        }

        @Generated
        public MetadataResolver getMetadataResolver() {
            return this.metadataResolver;
        }

        @Generated
        public Optional<EntityDescriptor> getEntityDescriptor() {
            return this.entityDescriptor;
        }

        @Generated
        private static final class MetadataResolverCacheQueryResultBuilderImpl
        extends MetadataResolverCacheQueryResultBuilder<MetadataResolverCacheQueryResult, MetadataResolverCacheQueryResultBuilderImpl> {
            @Generated
            private MetadataResolverCacheQueryResultBuilderImpl() {
            }

            @Override
            @Generated
            protected MetadataResolverCacheQueryResultBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public MetadataResolverCacheQueryResult build() {
                return new MetadataResolverCacheQueryResult(this);
            }
        }

        @Generated
        public static abstract class MetadataResolverCacheQueryResultBuilder<C extends MetadataResolverCacheQueryResult, B extends MetadataResolverCacheQueryResultBuilder<C, B>> {
            @Generated
            private MetadataResolver metadataResolver;
            @Generated
            private boolean entityDescriptor$set;
            @Generated
            private Optional<EntityDescriptor> entityDescriptor$value;

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public B metadataResolver(MetadataResolver metadataResolver) {
                this.metadataResolver = metadataResolver;
                return this.self();
            }

            @Generated
            public B entityDescriptor(Optional<EntityDescriptor> entityDescriptor) {
                this.entityDescriptor$value = entityDescriptor;
                this.entityDescriptor$set = true;
                return this.self();
            }

            @Generated
            public String toString() {
                return "SamlRegisteredServiceDefaultCachingMetadataResolver.MetadataResolverCacheQueryResult.MetadataResolverCacheQueryResultBuilder(metadataResolver=" + this.metadataResolver + ", entityDescriptor$value=" + this.entityDescriptor$value + ")";
            }
        }
    }

    private static class MetadataResolutionResult {
        private final boolean valid;
        private final Optional<EntityDescriptor> entityDescriptor;
        private final MetadataResolver metadataResolver;

        @Generated
        protected MetadataResolutionResult(MetadataResolutionResultBuilder<?, ?> b) {
            this.valid = b.valid;
            this.entityDescriptor = b.entityDescriptor;
            this.metadataResolver = b.metadataResolver;
        }

        @Generated
        public static MetadataResolutionResultBuilder<?, ?> builder() {
            return new MetadataResolutionResultBuilderImpl();
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }

        @Generated
        public Optional<EntityDescriptor> getEntityDescriptor() {
            return this.entityDescriptor;
        }

        @Generated
        public MetadataResolver getMetadataResolver() {
            return this.metadataResolver;
        }

        @Generated
        private static final class MetadataResolutionResultBuilderImpl
        extends MetadataResolutionResultBuilder<MetadataResolutionResult, MetadataResolutionResultBuilderImpl> {
            @Generated
            private MetadataResolutionResultBuilderImpl() {
            }

            @Override
            @Generated
            protected MetadataResolutionResultBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public MetadataResolutionResult build() {
                return new MetadataResolutionResult(this);
            }
        }

        @Generated
        public static abstract class MetadataResolutionResultBuilder<C extends MetadataResolutionResult, B extends MetadataResolutionResultBuilder<C, B>> {
            @Generated
            private boolean valid;
            @Generated
            private Optional<EntityDescriptor> entityDescriptor;
            @Generated
            private MetadataResolver metadataResolver;

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public B valid(boolean valid) {
                this.valid = valid;
                return this.self();
            }

            @Generated
            public B entityDescriptor(Optional<EntityDescriptor> entityDescriptor) {
                this.entityDescriptor = entityDescriptor;
                return this.self();
            }

            @Generated
            public B metadataResolver(MetadataResolver metadataResolver) {
                this.metadataResolver = metadataResolver;
                return this.self();
            }

            @Generated
            public String toString() {
                return "SamlRegisteredServiceDefaultCachingMetadataResolver.MetadataResolutionResult.MetadataResolutionResultBuilder(valid=" + this.valid + ", entityDescriptor=" + this.entityDescriptor + ", metadataResolver=" + this.metadataResolver + ")";
            }
        }
    }
}

