/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response.soap;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11ResponseBuilder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultActor;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.opensaml.soap.soap11.Header;

public class SamlProfileSamlSoap11FaultResponseBuilder
extends SamlProfileSamlSoap11ResponseBuilder {
    private static final long serialVersionUID = -1875903354216171261L;

    public SamlProfileSamlSoap11FaultResponseBuilder(SamlProfileSamlResponseBuilderConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    public Envelope build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, AuthenticatedAssertionContext casAssertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        Body body = (Body)SamlUtils.newSoapObject(Body.class);
        Fault fault = (Fault)SamlUtils.newSoapObject(Fault.class);
        FaultCode faultCode = (FaultCode)SamlUtils.newSoapObject(FaultCode.class);
        faultCode.setValue(FaultCode.SERVER);
        fault.setCode(faultCode);
        FaultActor faultActor = (FaultActor)SamlUtils.newSoapObject(FaultActor.class);
        faultActor.setURI(SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest));
        fault.setActor(faultActor);
        FaultString faultString = (FaultString)SamlUtils.newSoapObject(FaultString.class);
        Object error = request.getAttribute("samlError");
        if (error != null) {
            faultString.setValue(error.toString());
        } else {
            faultString.setValue("SOAP failure");
        }
        fault.setMessage(faultString);
        body.getUnknownXMLObjects().add(fault);
        Envelope envelope = (Envelope)SamlUtils.newSoapObject(Envelope.class);
        Header header = (Header)SamlUtils.newSoapObject(Header.class);
        envelope.setHeader(header);
        envelope.setBody(body);
        SOAP11Context ctx = (SOAP11Context)messageContext.getSubcontext(SOAP11Context.class, true);
        Objects.requireNonNull(ctx).setHTTPResponseStatus(Integer.valueOf(200));
        this.encodeFinalResponse(request, response, service, adaptor, envelope, binding, authnRequest, casAssertion, messageContext);
        request.setAttribute(FaultString.class.getSimpleName(), error);
        return envelope;
    }
}

