/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.sso;

import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPCoreProperties;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidator;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class SSOSamlIdPProfileCallbackHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOSamlIdPProfileCallbackHandlerController.class);

    public SSOSamlIdPProfileCallbackHandlerController(SamlProfileHandlerConfigurationContext config) {
        super(config);
    }

    @GetMapping(path={"/idp/profile/SAML2/Callback"})
    protected ModelAndView handleCallbackProfileRequestGet(HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.autoConfigureCookiePath(request);
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        SamlIdPCoreProperties.SessionStorageTypes type = properties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type == SamlIdPCoreProperties.SessionStorageTypes.BROWSER_SESSION_STORAGE && !request.getParameterMap().containsKey("sessionStorage")) {
            return new ModelAndView("storage/casSessionStorageReadView");
        }
        return this.handleProfileRequest(response, request);
    }

    @PostMapping(path={"/idp/profile/SAML2/Callback"})
    protected ModelAndView handleCallbackProfileRequestPost(HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.autoConfigureCookiePath(request);
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        SamlIdPCoreProperties.SessionStorageTypes type = properties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type == SamlIdPCoreProperties.SessionStorageTypes.BROWSER_SESSION_STORAGE) {
            String storage = request.getParameter("sessionStorage");
            JEEContext context = new JEEContext(request, response);
            this.configurationContext.getSessionStore().buildFromTrackableSession((WebContext)context, (Object)storage);
            return this.handleProfileRequest(response, request);
        }
        return WebUtils.produceErrorView((Exception)new IllegalArgumentException("Unable to build SAML response"));
    }

    private ModelAndView handleProfileRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        Pair<? extends RequestAbstractType, MessageContext> authnContext = this.retrieveAuthenticationRequest(response, request);
        String ticket = request.getParameter("ticket");
        if (StringUtils.isBlank((CharSequence)ticket)) {
            LOGGER.error("Can not validate the request because no [{}] is provided via the request", (Object)"ticket");
            return WebUtils.produceErrorView((Exception)new IllegalArgumentException("Unable to handle SAML request"));
        }
        Pair<? extends RequestAbstractType, MessageContext> authenticationContext = this.buildAuthenticationContextPair(request, response, authnContext);
        AuthenticatedAssertionContext assertion = this.validateRequestAndBuildCasAssertion(response, request, authenticationContext);
        String binding = this.determineProfileBinding(authenticationContext);
        if (StringUtils.isBlank((CharSequence)binding)) {
            LOGGER.error("Unable to determine profile binding");
            return WebUtils.produceErrorView((Exception)new IllegalArgumentException("Unable to determine profile binding"));
        }
        this.buildSamlResponse(response, request, authenticationContext, assertion, binding);
        return null;
    }

    private AuthenticatedAssertionContext validateRequestAndBuildCasAssertion(HttpServletResponse response, HttpServletRequest request, Pair<? extends RequestAbstractType, MessageContext> authnContext) throws Exception {
        String ticket = request.getParameter("ticket");
        TicketValidator validator = this.getConfigurationContext().getTicketValidator();
        String serviceUrl = this.constructServiceUrl(request, response, authnContext);
        LOGGER.trace("Created service url for validation: [{}]", (Object)serviceUrl);
        Assertion assertion = validator.validate(ticket, serviceUrl);
        SSOSamlIdPProfileCallbackHandlerController.logCasValidationAssertion(assertion);
        return ((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)AuthenticatedAssertionContext.builder().name(assertion.getPrincipal().getName())).authenticationDate(DateTimeUtils.zonedDateTimeOf((Date)assertion.getAuthenticationDate()))).validFromDate(DateTimeUtils.zonedDateTimeOf((Date)assertion.getValidFromDate()))).validUntilDate(DateTimeUtils.zonedDateTimeOf((Date)assertion.getValidUntilDate()))).attributes(CollectionUtils.merge((Map[])new Map[]{assertion.getAttributes(), assertion.getPrincipal().getAttributes()}))).build();
    }
}

