/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketImpl;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="SamlIdPTicketCatalogConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPTicketCatalogConfiguration
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPTicketCatalogConfiguration.class);

    public void configureTicketCatalog(TicketCatalog plan, CasConfigurationProperties casProperties) {
        LOGGER.debug("Registering SAML2 protocol ticket definitions...");
        this.buildAndRegisterSamlArtifactDefinition(plan, this.buildTicketDefinition(plan, "SART", SamlArtifactTicketImpl.class, Integer.MIN_VALUE), casProperties);
        this.buildAndRegisterSamlAttributeQueryDefinition(plan, this.buildTicketDefinition(plan, "SATQ", SamlAttributeQueryTicketImpl.class, Integer.MIN_VALUE), casProperties);
    }

    protected void buildAndRegisterSamlArtifactDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getSamlIdp().getTicket().getSamlArtifactsCacheStorageName());
        metadata.getProperties().setStorageTimeout(casProperties.getTicket().getSt().getTimeToKillInSeconds());
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterSamlAttributeQueryDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getSamlIdp().getTicket().getSamlAttributeQueryCacheStorageName());
        metadata.getProperties().setStorageTimeout(casProperties.getTicket().getSt().getTimeToKillInSeconds());
        this.registerTicketDefinition(plan, metadata);
    }
}

