/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnMultiValuedProperty;
import org.apereo.cas.web.flow.SpnegoCredentialsAction;
import org.apereo.cas.web.flow.SpnegoNegotiateCredentialsAction;
import org.apereo.cas.web.flow.client.BaseSpnegoKnownClientSystemsFilterAction;
import org.apereo.cas.web.flow.client.HostNameSpnegoKnownClientSystemsFilterAction;
import org.apereo.cas.web.flow.client.LdapSpnegoKnownClientSystemsFilterAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.execution.Action;

@Configuration(value="SpnegoWebflowActionsConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SpnegoWebflowActionsConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action spnego(CasConfigurationProperties casProperties, @Qualifier(value="adaptiveAuthenticationPolicy") AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, @Qualifier(value="serviceTicketRequestWebflowEventResolver") CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver) {
        SpnegoProperties spnegoProperties = casProperties.getAuthn().getSpnego();
        return new SpnegoCredentialsAction(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy, spnegoProperties.isNtlm(), spnegoProperties.isSend401OnAuthenticationFailure());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action negociateSpnego(CasConfigurationProperties casProperties) {
        SpnegoProperties spnegoProperties = casProperties.getAuthn().getSpnego();
        List<String> supportedBrowsers = Stream.of(spnegoProperties.getSupportedBrowsers().split(",")).collect(Collectors.toList());
        return new SpnegoNegotiateCredentialsAction(supportedBrowsers, spnegoProperties.isNtlm(), spnegoProperties.isMixedModeAuthentication());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action baseSpnegoClientAction(CasConfigurationProperties casProperties) {
        SpnegoProperties spnegoProperties = casProperties.getAuthn().getSpnego();
        return new BaseSpnegoKnownClientSystemsFilterAction(RegexUtils.createPattern((String)spnegoProperties.getIpsToCheckPattern()), spnegoProperties.getAlternativeRemoteHostAttribute(), Beans.newDuration((String)spnegoProperties.getDnsTimeout()).toMillis());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action hostnameSpnegoClientAction(CasConfigurationProperties casProperties) {
        SpnegoProperties spnegoProperties = casProperties.getAuthn().getSpnego();
        return new HostNameSpnegoKnownClientSystemsFilterAction(RegexUtils.createPattern((String)spnegoProperties.getIpsToCheckPattern()), spnegoProperties.getAlternativeRemoteHostAttribute(), Beans.newDuration((String)spnegoProperties.getDnsTimeout()).toMillis(), spnegoProperties.getHostNamePatternString());
    }

    @ConditionalOnMultiValuedProperty(name="cas.authn.spnego.ldap", value={"ldap-url"})
    @Configuration(value="SpnegoLdapWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SpnegoLdapWebflowActionsConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action ldapSpnegoClientAction(CasConfigurationProperties casProperties) {
            SpnegoProperties spnegoProperties = casProperties.getAuthn().getSpnego();
            ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)spnegoProperties.getLdap());
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)spnegoProperties.getLdap().getSearchFilter());
            SearchRequest searchRequest = LdapUtils.newLdaptiveSearchRequest((String)spnegoProperties.getLdap().getBaseDn(), (FilterTemplate)filter);
            SearchOperation searchOperation = new SearchOperation(connectionFactory, searchRequest);
            searchOperation.setTemplate(filter);
            return new LdapSpnegoKnownClientSystemsFilterAction(RegexUtils.createPattern((String)spnegoProperties.getIpsToCheckPattern()), spnegoProperties.getAlternativeRemoteHostAttribute(), Beans.newDuration((String)spnegoProperties.getDnsTimeout()).toMillis(), searchOperation, spnegoProperties.getSpnegoAttributeName());
        }
    }
}

