/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.nio.charset.Charset;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.flow.actions.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class SpnegoCredentialsAction
extends AbstractNonInteractiveCredentialsAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoCredentialsAction.class);
    private final boolean ntlm;
    private final String messageBeginPrefix;
    private final boolean send401OnAuthenticationFailure;

    public SpnegoCredentialsAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, boolean ntlm, boolean send401OnAuthenticationFailure) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.ntlm = ntlm;
        this.messageBeginPrefix = (ntlm ? "NTLM" : "Negotiate") + " ";
        this.send401OnAuthenticationFailure = send401OnAuthenticationFailure;
    }

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        int prefixLength;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        LOGGER.debug("Available request headers are [{}]", Collections.list(request.getHeaderNames()));
        String authorizationHeader = StringUtils.defaultString((String)request.getHeader("Authorization"), (String)request.getHeader("Authorization".toLowerCase()));
        LOGGER.debug("SPNEGO Authorization header located as [{}]", (Object)authorizationHeader);
        if (StringUtils.isBlank((CharSequence)authorizationHeader)) {
            LOGGER.warn("SPNEGO Authorization header is not found under [{}]", (Object)"Authorization");
            return null;
        }
        int authzHeaderLength = authorizationHeader.length();
        if (authzHeaderLength > (prefixLength = this.messageBeginPrefix.length()) && authorizationHeader.startsWith(this.messageBeginPrefix)) {
            LOGGER.debug("SPNEGO Authorization header found with [{}] bytes", (Object)(authzHeaderLength - prefixLength));
            String base64 = authorizationHeader.substring(prefixLength);
            byte[] token = EncodingUtils.decodeBase64((String)base64);
            String tokenString = new String(token, Charset.defaultCharset());
            LOGGER.debug("Obtained token: [{}]. Creating credential...", (Object)tokenString);
            return new SpnegoCredential(token);
        }
        LOGGER.warn("SPNEGO Authorization header [{}] does not begin with the prefix [{}]", (Object)authorizationHeader, (Object)this.messageBeginPrefix);
        return null;
    }

    protected void onError(RequestContext context) {
        this.setResponseHeader(context);
    }

    protected void onSuccess(RequestContext context) {
        this.setResponseHeader(context);
    }

    private void setResponseHeader(RequestContext context) {
        Credential credential = WebUtils.getCredential((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        SpnegoCredential spnegoCredentials = (SpnegoCredential)credential;
        byte[] nextToken = spnegoCredentials.getNextToken();
        if (nextToken != null) {
            LOGGER.debug("Obtained output token: [{}]", (Object)new String(nextToken, Charset.defaultCharset()));
            response.setHeader("WWW-Authenticate", (this.ntlm ? "NTLM" : "Negotiate") + " " + EncodingUtils.encodeBase64((byte[])nextToken));
        } else {
            LOGGER.debug("Unable to obtain the output token required.");
        }
        if (spnegoCredentials.getPrincipal() == null && this.send401OnAuthenticationFailure) {
            LOGGER.debug("Setting HTTP Status to 401");
            response.setStatus(401);
        }
    }
}

