/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class SpnegoWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public SpnegoWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(casProperties.getAuthn().getSpnego().getWebflow().getOrder());
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createStartSpnegoAction(flow);
            this.createEvaluateSpnegoClientAction(flow);
            this.createSpnegoActionState(flow);
            this.augmentWebflowToStartSpnego(flow);
        }
    }

    private void augmentWebflowToStartSpnego(Flow flow) {
        ActionState state = (ActionState)this.getState(flow, "afterInitializeLoginForm", ActionState.class);
        if (this.casProperties.getAuthn().getSpnego().isMixedModeAuthentication()) {
            this.createTransitionForState((TransitionableState)state, "success", "evaluateClientRequest", true);
        } else {
            this.createTransitionForState((TransitionableState)state, "success", "startSpnegoAuthenticate", true);
        }
    }

    private void createStartSpnegoAction(Flow flow) {
        ActionState actionState = this.createActionState(flow, "startSpnegoAuthenticate", new String[]{"negociateSpnego"});
        TransitionSet transitionSet = actionState.getTransitionSet();
        transitionSet.add(this.createTransition("success", "spnego"));
        transitionSet.add(this.createTransition("error", this.getStateIdOnSpnegoFailure(flow)));
    }

    private void createEvaluateSpnegoClientAction(Flow flow) {
        ActionState evaluateClientRequest = this.createActionState(flow, "evaluateClientRequest", new String[]{this.casProperties.getAuthn().getSpnego().getHostNameClientActionStrategy()});
        TransitionSet transitionSet = evaluateClientRequest.getTransitionSet();
        transitionSet.add(this.createTransition("yes", "startSpnegoAuthenticate"));
        transitionSet.add(this.createTransition("no", this.getStateIdOnSpnegoFailure(flow)));
    }

    private void createSpnegoActionState(Flow flow) {
        ActionState spnego = this.createActionState(flow, "spnego", new String[]{"spnego"});
        TransitionSet transitions = spnego.getTransitionSet();
        transitions.add(this.createTransition("success", "createTicketGrantingTicket"));
        transitions.add(this.createTransition("error", this.getStateIdOnSpnegoFailure(flow)));
        transitions.add(this.createTransition("warn", "warn"));
        transitions.add(this.createTransition("authenticationFailure", "viewLoginForm"));
        transitions.add(this.createTransition("successWithWarnings", "showAuthenticationWarningMessages"));
        spnego.getExitActionList().add((Action)this.createEvaluateAction("clearWebflowCredentialsAction"));
    }

    private String getStateIdOnSpnegoFailure(Flow flow) {
        ActionState state = (ActionState)this.getState(flow, "afterInitializeLoginForm", ActionState.class);
        return state.getTransition("success").getTargetStateId();
    }
}

