/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.thymeleaf.context.WebEngineContext;

public class CasThymeleafLoginFormDirector {
    private final CasWebflowExecutionPlan webflowExecutionPlan;

    public boolean isLoginFormViewable(WebEngineContext vars) {
        RequestContext context = RequestContextHolder.getRequestContext();
        return context != null && WebUtils.getDelegatedAuthenticationProviderPrimary((RequestContext)context) == null && WebUtils.isCasLoginFormViewable((RequestContext)context);
    }

    public boolean isLoginFormUsernameInputVisible(WebEngineContext vars) {
        RequestContext context = RequestContextHolder.getRequestContext();
        return context != null && WebUtils.isCasLoginFormViewable((RequestContext)context) && WebUtils.getPasswordlessAuthenticationAccount((RequestContext)context, Serializable.class) == null;
    }

    public boolean isLoginFormUsernameInputDisabled(WebEngineContext vars) {
        RequestContext context = RequestContextHolder.getRequestContext();
        return context == null || !WebUtils.isCasLoginFormViewable((RequestContext)context) || WebUtils.isGraphicalUserAuthenticationEnabled((RequestContext)context) || WebUtils.getPasswordlessAuthenticationAccount((RequestContext)context, Serializable.class) != null;
    }

    public String getLoginFormUsername(WebEngineContext vars) {
        RequestContext context = RequestContextHolder.getRequestContext();
        if (context != null && WebUtils.isCasLoginFormViewable((RequestContext)context)) {
            return this.webflowExecutionPlan.getWebflowLoginContextProviders().stream().map(provider -> provider.getCandidateUsername(context)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse("");
        }
        return "";
    }

    @Generated
    public CasThymeleafLoginFormDirector(CasWebflowExecutionPlan webflowExecutionPlan) {
        this.webflowExecutionPlan = webflowExecutionPlan;
    }
}

