/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.metadata;

import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.stream.XMLStreamWriter;
import lombok.Generated;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.core.util.SignatureUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationSecurityTokenServiceProperties;
import org.apereo.cas.support.util.CryptoUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.ws.idp.WSFederationClaims;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSFederationMetadataWriter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WSFederationMetadataWriter.class);

    public static Document produceMetadataDocument(CasConfigurationProperties config) throws Exception {
        WsFederationProperties wsfedIdp = config.getAuthn().getWsfedIdp();
        WsFederationSecurityTokenServiceProperties sts = wsfedIdp.getSts();
        Properties prop = CryptoUtils.getSecurityProperties((String)sts.getRealm().getKeystoreFile(), (String)sts.getRealm().getKeystorePassword(), (String)sts.getRealm().getKeystoreAlias());
        Crypto crypto = CryptoFactory.getInstance((Properties)prop);
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
        String referenceID = IDGenerator.generateID((String)"_");
        writer.writeStartElement("md", "EntityDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("ID", referenceID);
        String idpEntityId = config.getServer().getPrefix().concat("/ws/idp/federation");
        writer.writeAttribute("entityID", idpEntityId);
        writer.writeNamespace("md", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeNamespace("fed", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
        writer.writeNamespace("auth", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        String stsUrl = config.getServer().getPrefix().concat("/ws/sts/").concat(wsfedIdp.getIdp().getRealmName());
        WSFederationMetadataWriter.writeFederationMetadata((XMLStreamWriter)writer, idpEntityId, stsUrl, crypto);
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        String out = DOM2Writer.nodeToString((Node)writer.getDocument());
        LOGGER.trace(out);
        return SignatureUtils.signMetaInfo((Crypto)crypto, null, (String)sts.getRealm().getKeyPassword(), (Document)writer.getDocument(), (String)referenceID);
    }

    private static void writeFederationMetadata(XMLStreamWriter writer, String idpEntityId, String ststUrl, Crypto crypto) throws Exception {
        writer.writeStartElement("md", "RoleDescriptor", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "fed:SecurityTokenServiceType");
        writer.writeAttribute("protocolSupportEnumeration", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("", "KeyDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("use", "signing");
        writer.writeStartElement("", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        writer.writeStartElement("", "X509Data", "http://www.w3.org/2000/09/xmldsig#");
        writer.writeStartElement("", "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
        String keyAlias = crypto.getDefaultX509Identifier();
        X509Certificate cert = CertsUtils.getX509CertificateFromCrypto((Crypto)crypto, (String)keyAlias);
        writer.writeCharacters(EncodingUtils.encodeBase64((byte[])cert.getEncoded()));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("fed", "SecurityTokenServiceEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
        writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
        writer.writeCharacters(ststUrl);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("fed", "PassiveRequestorEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
        writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
        writer.writeCharacters(idpEntityId);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("fed", "ClaimTypesOffered", "http://docs.oasis-open.org/wsfed/federation/200706");
        Arrays.stream(WSFederationClaims.values()).forEach(Unchecked.consumer(claim -> {
            writer.writeStartElement("auth", "ClaimType", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeAttribute("Uri", claim.getUri());
            writer.writeAttribute("Optional", "true");
            writer.writeEndElement();
        }));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    @Generated
    public WSFederationMetadataWriter() {
    }
}

