/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.services;

import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.SecurityTokenServiceClient;
import org.apereo.cas.authentication.SecurityTokenServiceClientBuilder;
import org.apereo.cas.ticket.TicketValidator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.ws.idp.WSFederationClaims;
import org.apereo.cas.ws.idp.WSFederationConstants;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.apereo.cas.ws.idp.services.WSFederationRelyingPartyTokenProducer;
import org.apereo.cas.ws.idp.web.WSFederationRequest;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DefaultRelyingPartyTokenProducer
implements WSFederationRelyingPartyTokenProducer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRelyingPartyTokenProducer.class);
    private final SecurityTokenServiceClientBuilder clientBuilder;
    private final CipherExecutor<String, String> credentialCipherExecutor;
    private final Set<String> customClaims;

    private static String serializeRelyingPartyToken(Element rpToken) throws Exception {
        StringWriter sw = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t = transformerFactory.newTransformer();
        t.setOutputProperty("omit-xml-declaration", BooleanUtils.toStringYesNo((Boolean)Boolean.TRUE));
        t.transform(new DOMSource(rpToken), new StreamResult(sw));
        return sw.toString();
    }

    @Override
    public String produce(SecurityToken securityToken, WSFederationRegisteredService service, WSFederationRequest fedRequest, HttpServletRequest request, TicketValidator.ValidationResult assertion) throws Exception {
        SecurityTokenServiceClient sts = this.clientBuilder.buildClientForRelyingPartyTokenResponses(securityToken, service);
        this.mapAttributesToRequestedClaims(service, sts, assertion);
        Element rpToken = this.requestSecurityTokenResponse(service, sts, assertion);
        return DefaultRelyingPartyTokenProducer.serializeRelyingPartyToken(rpToken);
    }

    protected void writeAttributeValue(W3CDOMStreamWriter writer, String uri, Object attributeValue, WSFederationRegisteredService service) throws Exception {
        LOGGER.trace("Mapping attribute [{}] with value [{}] for service [{}]", new Object[]{uri, attributeValue, service.getServiceId()});
        writer.writeStartElement("ic", "ClaimValue", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        writer.writeAttribute("Uri", uri);
        writer.writeAttribute("Optional", Boolean.TRUE.toString());
        Set values = CollectionUtils.toCollection((Object)attributeValue);
        for (Object value : values) {
            writer.writeStartElement("ic", "Value", "http://schemas.xmlsoap.org/ws/2005/05/identity");
            writer.writeCharacters(value.toString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void mapAttributesToRequestedClaims(WSFederationRegisteredService service, SecurityTokenServiceClient sts, TicketValidator.ValidationResult assertion) throws Exception {
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartElement("wst", "Claims", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        writer.writeNamespace("wst", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        writer.writeNamespace("ic", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        writer.writeAttribute("Dialect", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        Map attributes = assertion.getPrincipal().getAttributes();
        LOGGER.debug("Mapping principal attributes [{}] to claims for service [{}]", (Object)attributes, (Object)service);
        attributes.forEach(Unchecked.biConsumer((k, v) -> {
            String claimName = ProtocolAttributeEncoder.decodeAttribute((String)k);
            if (WSFederationClaims.contains((String)claimName)) {
                String uri = WSFederationClaims.valueOf((String)k).getUri();
                LOGGER.debug("Requested claim [{}] mapped to [{}]", k, (Object)uri);
                this.writeAttributeValue(writer, uri, v, service);
            } else if (WSFederationClaims.containsUri((String)claimName)) {
                LOGGER.debug("Requested claim [{}] directly mapped to [{}]", k, (Object)claimName);
                this.writeAttributeValue(writer, claimName, v, service);
            } else if (this.customClaims.contains(claimName)) {
                LOGGER.debug("Requested custom claim [{}]", (Object)claimName);
                this.writeAttributeValue(writer, claimName, v, service);
            } else {
                LOGGER.debug("Requested claim [{}] is not defined/supported by CAS", (Object)claimName);
                this.writeAttributeValue(writer, WSFederationConstants.getClaimInCasNamespace((String)claimName), v, service);
            }
        }));
        writer.writeEndElement();
        Element claims = writer.getDocument().getDocumentElement();
        sts.setClaims((Object)claims);
    }

    private Element requestSecurityTokenResponse(WSFederationRegisteredService service, SecurityTokenServiceClient sts, TicketValidator.ValidationResult assertion) {
        try {
            Map properties = sts.getProperties();
            properties.put("security.username", assertion.getPrincipal().getId());
            String uid = (String)this.credentialCipherExecutor.encode((Object)assertion.getPrincipal().getId());
            properties.put("security.password", uid);
            return (Element)FunctionUtils.doUnchecked(() -> sts.requestSecurityTokenResponse(service.getAppliesTo()));
        }
        catch (SoapFault ex) {
            if (ex.getFaultCode() != null && "RequestFailed".equals(ex.getFaultCode().getLocalPart())) {
                throw new IllegalArgumentException((Throwable)new ProcessingException(ProcessingException.TYPE.BAD_REQUEST));
            }
            LoggingUtils.error((Logger)LOGGER, (Throwable)ex);
            throw ex;
        }
    }

    @Generated
    public DefaultRelyingPartyTokenProducer(SecurityTokenServiceClientBuilder clientBuilder, CipherExecutor<String, String> credentialCipherExecutor, Set<String> customClaims) {
        this.clientBuilder = clientBuilder;
        this.credentialCipherExecutor = credentialCipherExecutor;
        this.customClaims = customClaims;
    }
}

