/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.SecurityTokenServiceClient;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationProperties;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;

public class SecurityTokenServiceClientBuilder {
    private final WsFederationProperties wsFederationProperties;
    private final String prefix;
    private final HostnameVerifier hostnameVerifier;
    private final CasSSLContext sslContext;

    public SecurityTokenServiceClient buildClientForSecurityTokenRequests(WSFederationRegisteredService service) {
        Bus cxfBus = BusFactory.getDefaultBus();
        SecurityTokenServiceClient sts = new SecurityTokenServiceClient(cxfBus);
        sts.setAddressingNamespace((String)StringUtils.defaultIfBlank((CharSequence)service.getAddressingNamespace(), (CharSequence)"http://www.w3.org/2005/08/addressing"));
        sts.setTokenType((String)StringUtils.defaultIfBlank((CharSequence)service.getTokenType(), (CharSequence)"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        sts.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        sts.setWsdlLocation(this.prepareWsdlLocation(service));
        if (StringUtils.isNotBlank((CharSequence)service.getPolicyNamespace())) {
            sts.setWspNamespace(service.getPolicyNamespace());
        }
        String namespace = (String)StringUtils.defaultIfBlank((CharSequence)service.getNamespace(), (CharSequence)"http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
        sts.setServiceQName(new QName(namespace, (String)StringUtils.defaultIfBlank((CharSequence)service.getWsdlService(), (CharSequence)"SecurityTokenService")));
        sts.setEndpointQName(new QName(namespace, service.getWsdlEndpoint()));
        sts.setEnableAppliesTo(StringUtils.isNotBlank((CharSequence)service.getAppliesTo()));
        sts.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        sts.getProperties().putAll(new HashMap(0));
        sts.setTokenType((String)StringUtils.defaultIfBlank((CharSequence)service.getTokenType(), (CharSequence)"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        if (StringUtils.isNotBlank((CharSequence)service.getPolicyNamespace())) {
            sts.setWspNamespace(service.getPolicyNamespace());
        }
        TLSClientParameters tlsClientParams = this.getTlsClientParameters();
        sts.setTlsClientParameters(tlsClientParams);
        CasHTTPConduitConfigurer configurer = new CasHTTPConduitConfigurer(tlsClientParams);
        cxfBus.setExtension((Object)configurer, HTTPConduitConfigurer.class);
        return sts;
    }

    public SecurityTokenServiceClient buildClientForRelyingPartyTokenResponses(SecurityToken securityToken, WSFederationRegisteredService service) {
        SecurityTokenServiceClient sts = this.buildClientForSecurityTokenRequests(service);
        sts.setOnBehalfOf(securityToken.getToken());
        return sts;
    }

    private TLSClientParameters getTlsClientParameters() {
        TLSClientParameters tlsClientParams = new TLSClientParameters();
        tlsClientParams.setHostnameVerifier(this.hostnameVerifier);
        tlsClientParams.setSslContext(this.sslContext.getSslContext());
        tlsClientParams.setSecureRandom(RandomUtils.getNativeInstance());
        tlsClientParams.setKeyManagers(this.sslContext.getKeyManagers());
        tlsClientParams.setTrustManagers(this.sslContext.getTrustManagers());
        tlsClientParams.setSSLSocketFactory(this.sslContext.getSslContext().getSocketFactory());
        return tlsClientParams;
    }

    private String prepareWsdlLocation(WSFederationRegisteredService service) {
        if (StringUtils.isNotBlank((CharSequence)service.getWsdlLocation())) {
            return service.getWsdlLocation();
        }
        String wsdl = String.format("/ws/sts/%s/STSServiceTransportUT?wsdl", this.wsFederationProperties.getIdp().getRealmName());
        return this.prefix.concat(wsdl);
    }

    @Generated
    public SecurityTokenServiceClientBuilder(WsFederationProperties wsFederationProperties, String prefix, HostnameVerifier hostnameVerifier, CasSSLContext sslContext) {
        this.wsFederationProperties = wsFederationProperties;
        this.prefix = prefix;
        this.hostnameVerifier = hostnameVerifier;
        this.sslContext = sslContext;
    }

    private static class CasHTTPConduitConfigurer
    implements HTTPConduitConfigurer {
        private final TLSClientParameters tlsClientParameters;

        public void configure(String name, String addr, HTTPConduit httpConduit) {
            httpConduit.setTlsClientParameters(this.tlsClientParameters);
        }

        @Generated
        public CasHTTPConduitConfigurer(TLSClientParameters tlsClientParameters) {
            this.tlsClientParameters = tlsClientParameters;
        }
    }
}

