/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.SecurityTokenTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.EncodingUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class DefaultSecurityTokenTicket
extends AbstractTicket
implements SecurityTokenTicket {
    private static final long serialVersionUID = 3940671352560102114L;
    @JsonProperty(value="ticketGrantingTicket")
    private TicketGrantingTicket ticketGrantingTicket;
    @JsonProperty
    private String securityToken;

    public DefaultSecurityTokenTicket(String id, TicketGrantingTicket ticketGrantingTicket, ExpirationPolicy expirationPolicy, String securityToken) {
        super(id, expirationPolicy);
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.securityToken = securityToken;
    }

    public Authentication getAuthentication() {
        return this.getTicketGrantingTicket().getAuthentication();
    }

    public String getPrefix() {
        return "STS";
    }

    @Override
    @JsonIgnore
    public SecurityToken getSecurityToken() {
        byte[] securityTokenBin = EncodingUtils.decodeBase64((String)this.securityToken);
        return (SecurityToken)SerializationUtils.deserialize((byte[])securityTokenBin);
    }

    @Generated
    public DefaultSecurityTokenTicket() {
    }

    @Generated
    public TicketGrantingTicket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }
}

