/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.ticket.DefaultSecurityTokenTicketFactory;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.SecurityTokenTicketFactory;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.WsFederationIdentityProvider)
@AutoConfiguration
public class CoreWsSecuritySecurityTokenTicketConfiguration {

    @Configuration(value="CoreWsSecuritySecurityTokenTicketPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenTicketPlanConfiguration {
        @ConditionalOnMissingBean(name={"securityTokenTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer securityTokenTicketFactoryConfigurer(@Qualifier(value="securityTokenTicketFactory") SecurityTokenTicketFactory securityTokenTicketFactory) {
            return () -> securityTokenTicketFactory;
        }
    }

    @Configuration(value="CoreWsSecuritySecurityTokenTicketFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CoreWsSecuritySecurityTokenTicketFactoryConfiguration {
        @ConditionalOnMissingBean(name={"securityTokenTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SecurityTokenTicketFactory securityTokenTicketFactory(@Qualifier(value="securityTokenTicketIdGenerator") UniqueTicketIdGenerator securityTokenTicketIdGenerator, @Qualifier(value="grantingTicketExpirationPolicy") ExpirationPolicyBuilder grantingTicketExpirationPolicy) {
            return new DefaultSecurityTokenTicketFactory(securityTokenTicketIdGenerator, grantingTicketExpirationPolicy);
        }

        @ConditionalOnMissingBean(name={"securityTokenTicketIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator securityTokenTicketIdGenerator() {
            return new DefaultUniqueTicketIdGenerator();
        }
    }
}

