/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.ActuatorEndpointProperties;
import org.apereo.cas.configuration.model.core.monitor.JaasSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.core.monitor.LdapSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.security.authentication.EndpointLdapAuthenticationProvider;
import org.jooq.lambda.Unchecked;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.servlet.PathRequest;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.jaas.JaasAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Order(value=1000)
public class CasWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWebSecurityConfigurerAdapter.class);
    public static final String ENDPOINT_URL_ADMIN_FORM_LOGIN = "/adminlogin";
    private final CasConfigurationProperties casProperties;
    private final SecurityProperties securityProperties;
    private final SecurityExpressionHandler<FilterInvocation> casWebSecurityExpressionHandler;
    private final ObjectProvider<PathMappedEndpoints> pathMappedEndpoints;
    private final List<ProtocolEndpointWebSecurityConfigurer> protocolEndpointWebSecurityConfigurers;
    private EndpointLdapAuthenticationProvider endpointLdapAuthenticationProvider;

    public void destroy() {
        if (this.endpointLdapAuthenticationProvider != null) {
            this.endpointLdapAuthenticationProvider.destroy();
        }
    }

    public void configure(WebSecurity web) {
        List patterns = this.protocolEndpointWebSecurityConfigurers.stream().map(ProtocolEndpointWebSecurityConfigurer::getIgnoredEndpoints).flatMap(Collection::stream).map(endpoint -> StringUtils.prependIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("/**")).collect(Collectors.toList());
        patterns.add("/webjars/**");
        patterns.add("/js/**");
        patterns.add("/css/**");
        patterns.add("/images/**");
        patterns.add("/static/**");
        patterns.add("/error");
        patterns.add("/favicon.ico");
        LOGGER.debug("Configuring protocol endpoints [{}] to exclude/ignore from web security", patterns);
        web.debug(LOGGER.isDebugEnabled()).ignoring().antMatchers((String[])patterns.toArray(String[]::new));
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        JaasSecurityActuatorEndpointsMonitorProperties jaas = this.casProperties.getMonitor().getEndpoints().getJaas();
        if (jaas.getLoginConfig() != null) {
            this.configureJaasAuthenticationProvider(auth, jaas);
        } else {
            LOGGER.trace("No JAAS login config is defined to enable JAAS authentication");
        }
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        if (StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter())) {
            this.configureLdapAuthenticationProvider(auth, ldap);
        } else {
            LOGGER.trace("No LDAP url or search filter is defined to enable LDAP authentication");
        }
        if (!auth.isConfigured()) {
            super.configure(auth);
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ChannelSecurityConfigurer.RequiresChannelUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).headers().disable()).logout().disable()).requiresChannel().requestMatchers(new RequestMatcher[]{r -> r.getHeader("X-Forwarded-Proto") != null})).requiresSecure();
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests = http.authorizeRequests().expressionHandler(this.casWebSecurityExpressionHandler);
        Map endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint();
        endpoints.forEach(Unchecked.biConsumer((k, v) -> {
            EndpointRequest.EndpointRequestMatcher endpoint = EndpointRequest.to((String[])new String[]{k});
            v.getAccess().forEach(Unchecked.consumer(access -> this.configureEndpointAccess(http, requests, (ActuatorEndpointProperties.EndpointAccessLevel)access, (ActuatorEndpointProperties)v, endpoint)));
        }));
        this.configureEndpointAccessToDenyUndefined(http, requests);
        this.configureEndpointAccessForStaticResources(requests);
        this.protocolEndpointWebSecurityConfigurers.forEach(cfg -> cfg.configure((Object)http));
    }

    protected void configureEndpointAccessToDenyUndefined(HttpSecurity http, ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests) {
        Set endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint().keySet();
        ActuatorEndpointProperties endpointDefaults = this.casProperties.getMonitor().getEndpoints().getDefaultEndpointProperties();
        ((PathMappedEndpoints)this.pathMappedEndpoints.getObject()).forEach(endpoint -> {
            String rootPath = endpoint.getRootPath();
            if (endpoints.contains(rootPath)) {
                LOGGER.trace("Endpoint security is defined for endpoint [{}]", (Object)rootPath);
            } else {
                List defaultAccessRules = endpointDefaults.getAccess();
                LOGGER.trace("Endpoint security is NOT defined for endpoint [{}]. Using default security rules [{}]", (Object)rootPath, (Object)endpointDefaults);
                EndpointRequest.EndpointRequestMatcher endpointRequest = EndpointRequest.to((String[])new String[]{rootPath}).excludingLinks();
                defaultAccessRules.forEach(Unchecked.consumer(access -> this.configureEndpointAccess(http, requests, (ActuatorEndpointProperties.EndpointAccessLevel)access, endpointDefaults, endpointRequest)));
            }
        });
    }

    protected void configureLdapAuthenticationProvider(AuthenticationManagerBuilder auth, LdapSecurityActuatorEndpointsMonitorProperties ldap) {
        if (this.isLdapAuthorizationActive()) {
            ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
            Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
            this.endpointLdapAuthenticationProvider = new EndpointLdapAuthenticationProvider(ldap, this.securityProperties, connectionFactory, authenticator);
            auth.authenticationProvider((AuthenticationProvider)this.endpointLdapAuthenticationProvider);
        } else {
            LOGGER.trace("LDAP authorization is undefined, given no LDAP url, base-dn, search filter or role/group filter is configured");
        }
    }

    protected void configureJaasAuthenticationProvider(AuthenticationManagerBuilder auth, JaasSecurityActuatorEndpointsMonitorProperties jaas) throws Exception {
        JaasAuthenticationProvider p = new JaasAuthenticationProvider();
        p.setLoginConfig(jaas.getLoginConfig());
        p.setLoginContextName(jaas.getLoginContextName());
        p.setRefreshConfigurationOnStartup(jaas.isRefreshConfigurationOnStartup());
        p.afterPropertiesSet();
        auth.authenticationProvider((AuthenticationProvider)p);
    }

    protected void configureEndpointAccessForStaticResources(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.antMatchers(new String[]{"/resources/**"})).permitAll().antMatchers(new String[]{"/static/**"})).permitAll();
    }

    protected void configureEndpointAccessByFormLogin(HttpSecurity http) throws Exception {
        if (this.casProperties.getMonitor().getEndpoints().isFormLoginEnabled()) {
            http.formLogin().loginPage(ENDPOINT_URL_ADMIN_FORM_LOGIN).permitAll();
        } else {
            http.formLogin().disable();
        }
    }

    protected void configureEndpointAccess(HttpSecurity httpSecurity, ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, ActuatorEndpointProperties.EndpointAccessLevel access, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        switch (access) {
            case AUTHORITY: {
                this.configureEndpointAccessByAuthority(requests, properties, endpoint);
                break;
            }
            case ROLE: {
                this.configureEndpointAccessByRole(requests, properties, endpoint);
                break;
            }
            case AUTHENTICATED: {
                this.configureEndpointAccessAuthenticated(requests, endpoint);
                break;
            }
            case IP_ADDRESS: {
                this.configureEndpointAccessByIpAddress(requests, properties, endpoint);
                break;
            }
            case PERMIT: {
                this.configureEndpointAccessPermitAll(requests, endpoint);
                break;
            }
            case ANONYMOUS: {
                this.configureEndpointAccessAnonymously(requests, endpoint);
                break;
            }
            default: {
                this.configureEndpointAccessToDenyAll(requests, endpoint);
            }
        }
    }

    private void configureEndpointAccessPermitAll(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).permitAll();
    }

    private void configureEndpointAccessToDenyAll(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).denyAll();
    }

    private void configureEndpointAccessAnonymously(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).anonymous();
    }

    private void configureEndpointAccessByIpAddress(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) {
        String addresses = properties.getRequiredIpAddresses().stream().map(address -> "hasIpAddress('" + address + "')").collect(Collectors.joining(" or "));
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).access(addresses);
    }

    private void configureEndpointAccessAuthenticated(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        HttpSecurity result = (HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).authenticated().and()).httpBasic().and();
        this.configureEndpointAccessByFormLogin(result);
    }

    private void configureEndpointAccessByRole(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        HttpSecurity result = (HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyRole(properties.getRequiredRoles().toArray(ArrayUtils.EMPTY_STRING_ARRAY)).and()).httpBasic().and();
        this.configureEndpointAccessByFormLogin(result);
    }

    private void configureEndpointAccessByAuthority(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        HttpSecurity result = (HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyAuthority(properties.getRequiredAuthorities().toArray(ArrayUtils.EMPTY_STRING_ARRAY)).and()).httpBasic().and();
        this.configureEndpointAccessByFormLogin(result);
    }

    private boolean isLdapAuthorizationActive() {
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        return StringUtils.isNotBlank((CharSequence)ldap.getBaseDn()) && StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter()) && (StringUtils.isNotBlank((CharSequence)ldap.getLdapAuthz().getRoleAttribute()) || StringUtils.isNotBlank((CharSequence)ldap.getLdapAuthz().getGroupAttribute()));
    }

    @Generated
    public CasWebSecurityConfigurerAdapter(CasConfigurationProperties casProperties, SecurityProperties securityProperties, SecurityExpressionHandler<FilterInvocation> casWebSecurityExpressionHandler, ObjectProvider<PathMappedEndpoints> pathMappedEndpoints, List<ProtocolEndpointWebSecurityConfigurer> protocolEndpointWebSecurityConfigurers) {
        this.casProperties = casProperties;
        this.securityProperties = securityProperties;
        this.casWebSecurityExpressionHandler = casWebSecurityExpressionHandler;
        this.pathMappedEndpoints = pathMappedEndpoints;
        this.protocolEndpointWebSecurityConfigurers = protocolEndpointWebSecurityConfigurers;
    }
}

