/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security;

import java.util.regex.Matcher;
import lombok.Generated;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;

public class CasWebSecurityExpressionRoot
extends WebSecurityExpressionRoot {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWebSecurityExpressionRoot.class);

    public CasWebSecurityExpressionRoot(Authentication a, FilterInvocation fi) {
        super(a, fi);
    }

    public boolean hasIpAddress(String ipAddress) {
        try {
            return super.hasIpAddress(ipAddress);
        }
        catch (Exception ex) {
            LOGGER.trace(ex.getMessage(), (Throwable)ex);
            String remoteAddr = this.request.getRemoteAddr();
            LOGGER.trace("Attempting to match [{}] against [{}] as a regular expression", (Object)remoteAddr, (Object)ipAddress);
            Matcher matcher = RegexUtils.createPattern((String)ipAddress, (int)2).matcher(remoteAddr);
            boolean result = matcher.matches();
            if (!result) {
                LOGGER.warn("Provided regular expression pattern [{}] does not match [{}]", (Object)ipAddress, (Object)remoteAddr);
            }
            return result;
        }
    }
}

