/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.HashMap;
import javax.servlet.Filter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpHeadersRequestProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpRequestProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpWebRequestProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.support.RegisteredServiceCorsConfigurationSource;
import org.apereo.cas.services.web.support.RegisteredServiceResponseHeadersEnforcementFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.AuthenticationCredentialsThreadLocalBinderClearingFilter;
import org.apereo.cas.web.support.filters.AddResponseHeadersFilter;
import org.apereo.cas.web.support.filters.RequestParameterPolicyEnforcementFilter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.CorsFilter;

@Configuration(value="CasFiltersConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasFiltersConfiguration {

    @Configuration(value="CasFiltersCorsConfiguration", proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="cas.http-web-request.cors", name={"enabled"}, havingValue="true")
    public static class CasFiltersCorsConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"corsConfigurationSource"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CorsConfigurationSource corsConfigurationSource(CasConfigurationProperties casProperties, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new RegisteredServiceCorsConfigurationSource(casProperties, servicesManager, argumentExtractor);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FilterRegistrationBean<CorsFilter> casCorsFilter(@Qualifier(value="corsConfigurationSource") CorsConfigurationSource corsConfigurationSource) {
            FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter(corsConfigurationSource), new ServletRegistrationBean[0]);
            bean.setName("casCorsFilter");
            bean.setAsyncSupported(true);
            bean.setOrder(0);
            return bean;
        }
    }

    @Configuration(value="CasFiltersResponseHeadersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureAfter(value={CasCoreServicesConfiguration.class})
    public static class CasFiltersResponseHeadersConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FilterRegistrationBean<AddResponseHeadersFilter> responseHeadersFilter(CasConfigurationProperties casProperties) {
            FilterRegistrationBean bean = new FilterRegistrationBean();
            AddResponseHeadersFilter filter = new AddResponseHeadersFilter();
            filter.setHeadersMap(casProperties.getHttpWebRequest().getCustomHeaders());
            bean.setFilter((Filter)filter);
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("responseHeadersFilter");
            bean.setAsyncSupported(true);
            return bean;
        }

        @ConditionalOnProperty(prefix="cas.http-web-request.header", name={"enabled"}, havingValue="true", matchIfMissing=true)
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FilterRegistrationBean<RegisteredServiceResponseHeadersEnforcementFilter> responseHeadersSecurityFilter(CasConfigurationProperties casProperties, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies) {
            HttpHeadersRequestProperties header = casProperties.getHttpWebRequest().getHeader();
            HashMap<String, String> initParams = new HashMap<String, String>();
            initParams.put("enableCacheControl", BooleanUtils.toStringTrueFalse((boolean)header.isCache()));
            initParams.put("enableXContentTypeOptions", BooleanUtils.toStringTrueFalse((boolean)header.isXcontent()));
            initParams.put("enableStrictTransportSecurity", BooleanUtils.toStringTrueFalse((boolean)header.isHsts()));
            initParams.put("enableXFrameOptions", BooleanUtils.toStringTrueFalse((boolean)header.isXframe()));
            initParams.put("XFrameOptions", header.getXframeOptions());
            initParams.put("enableXSSProtection", BooleanUtils.toStringTrueFalse((boolean)header.isXss()));
            initParams.put("XSSProtection", header.getXssOptions());
            if (StringUtils.isNotBlank((CharSequence)header.getContentSecurityPolicy())) {
                initParams.put("contentSecurityPolicy", header.getContentSecurityPolicy());
            }
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)new RegisteredServiceResponseHeadersEnforcementFilter(servicesManager, argumentExtractor, authenticationRequestServiceSelectionStrategies, registeredServiceAccessStrategyEnforcer));
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setInitParameters(initParams);
            bean.setName("responseHeadersSecurityFilter");
            bean.setAsyncSupported(true);
            return bean;
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FilterRegistrationBean<RequestParameterPolicyEnforcementFilter> requestParameterSecurityFilter(CasConfigurationProperties casProperties) {
            HttpRequestProperties httpWebRequest = casProperties.getHttpWebRequest();
            HashMap<String, String> initParams = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)httpWebRequest.getParamsToCheck())) {
                initParams.put("parametersToCheck", httpWebRequest.getParamsToCheck());
            }
            initParams.put("charactersToForbid", httpWebRequest.getCharactersToForbid());
            initParams.put("allowMultiValuedParameters", BooleanUtils.toStringTrueFalse((boolean)httpWebRequest.isAllowMultiValueParameters()));
            initParams.put("onlyPostParameters", httpWebRequest.getOnlyPostParams());
            initParams.put("throwOnError", Boolean.TRUE.toString());
            if (StringUtils.isNotBlank((CharSequence)httpWebRequest.getPatternToBlock())) {
                initParams.put("patternToBlock", httpWebRequest.getPatternToBlock());
            }
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)new RequestParameterPolicyEnforcementFilter());
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("requestParameterSecurityFilter");
            bean.setInitParameters(initParams);
            bean.setAsyncSupported(true);
            return bean;
        }
    }

    @Configuration(value="CasFiltersEncodingConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasFiltersBaseConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FilterRegistrationBean<CharacterEncodingFilter> characterEncodingFilter(CasConfigurationProperties casProperties) {
            FilterRegistrationBean bean = new FilterRegistrationBean();
            HttpWebRequestProperties web = casProperties.getHttpWebRequest().getWeb();
            bean.setFilter((Filter)new CharacterEncodingFilter(web.getEncoding(), web.isForceEncoding()));
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("characterEncodingFilter");
            bean.setAsyncSupported(true);
            return bean;
        }

        @Bean
        public FilterRegistrationBean<AuthenticationCredentialsThreadLocalBinderClearingFilter> currentCredentialsAndAuthenticationClearingFilter() {
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)new AuthenticationCredentialsThreadLocalBinderClearingFilter());
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("currentCredentialsAndAuthenticationClearingFilter");
            bean.setAsyncSupported(true);
            return bean;
        }
    }
}

