/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.LocaleCookieProperties;
import org.apereo.cas.configuration.model.core.web.LocaleProperties;
import org.apereo.cas.util.spring.RefreshableHandlerInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import org.springframework.web.servlet.mvc.UrlFilenameViewController;
import org.springframework.web.servlet.theme.ThemeChangeInterceptor;
import org.springframework.web.servlet.view.RedirectView;

@Configuration(value="CasWebAppConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasWebAppConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public ThemeChangeInterceptor themeChangeInterceptor(CasConfigurationProperties casProperties) {
        ThemeChangeInterceptor bean = new ThemeChangeInterceptor();
        bean.setParamName(casProperties.getTheme().getParamName());
        return bean;
    }

    @ConditionalOnMissingBean(name={"casLocaleResolver"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public LocaleResolver localeResolver(CasConfigurationProperties casProperties) {
        final LocaleProperties localeProps = casProperties.getLocale();
        LocaleCookieProperties localeCookie = localeProps.getCookie();
        CookieLocaleResolver resolver = new CookieLocaleResolver(){

            protected Locale determineDefaultLocale(HttpServletRequest request) {
                Locale locale = request.getLocale();
                if (StringUtils.isBlank((CharSequence)localeProps.getDefaultValue()) || !locale.getLanguage().equals(localeProps.getDefaultValue())) {
                    return locale;
                }
                return new Locale(localeProps.getDefaultValue());
            }
        };
        resolver.setCookieDomain(localeCookie.getDomain());
        resolver.setCookiePath((String)StringUtils.defaultIfBlank((CharSequence)localeCookie.getPath(), (CharSequence)"/"));
        resolver.setCookieHttpOnly(localeCookie.isHttpOnly());
        resolver.setCookieSecure(localeCookie.isSecure());
        resolver.setCookieName((String)StringUtils.defaultIfBlank((CharSequence)localeCookie.getName(), (CharSequence)CookieLocaleResolver.DEFAULT_COOKIE_NAME));
        resolver.setCookieMaxAge(Integer.valueOf(localeCookie.getMaxAge()));
        resolver.setLanguageTagCompliant(true);
        resolver.setRejectInvalidCookies(true);
        return resolver;
    }

    @Bean
    public SimpleUrlHandlerMapping handlerMapping(@Qualifier(value="rootController") Controller rootController) {
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        mapping.setOrder(1);
        mapping.setAlwaysUseFullPath(true);
        mapping.setRootHandler((Object)rootController);
        HashMap<String, Controller> urls = new HashMap<String, Controller>();
        urls.put("/", rootController);
        mapping.setUrlMap(urls);
        return mapping;
    }

    @Bean
    public WebMvcConfigurer casWebAppWebMvcConfigurer(final @Qualifier(value="localeChangeInterceptor") ObjectProvider<LocaleChangeInterceptor> localeChangeInterceptor) {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)new RefreshableHandlerInterceptor(localeChangeInterceptor)).addPathPatterns(new String[]{"/**"});
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"rootController"})
    public Controller rootController() {
        return new ParameterizableViewController(){

            protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
                String queryString = request.getQueryString();
                String url = request.getContextPath() + "/login" + Optional.ofNullable(queryString).map(string -> "?" + string).orElse("");
                return new ModelAndView((View)new RedirectView(response.encodeURL(url)));
            }
        };
    }

    @Bean
    protected UrlFilenameViewController passThroughController() {
        return new UrlFilenameViewController();
    }
}

