/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter;

import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.text.XTextGraphicObjectsSupplier;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XRefreshable;
import java.io.File;
import java.util.Map;
import org.artofsolving.jodconverter.office.OfficeContext;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeTask;
import org.artofsolving.jodconverter.office.OfficeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConversionTask
implements OfficeTask {
    private final File inputFile;
    private final File outputFile;

    public AbstractConversionTask(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    protected abstract Map<String, ?> getLoadProperties(File var1);

    protected abstract Map<String, ?> getStoreProperties(File var1, XComponent var2);

    @Override
    public void execute(OfficeContext context) throws OfficeException {
        XComponent document = null;
        try {
            document = this.loadDocument(context, this.inputFile);
            this.processDocument(document, context);
            this.storeDocument(document, this.outputFile);
        }
        catch (OfficeException officeException) {
            throw officeException;
        }
        catch (Exception exception) {
            throw new OfficeException("conversion failed", exception);
        }
        finally {
            if (document != null) {
                XCloseable closeable = OfficeUtils.cast(XCloseable.class, document);
                if (closeable != null) {
                    try {
                        closeable.close(true);
                    }
                    catch (CloseVetoException closeVetoException) {}
                } else {
                    document.dispose();
                }
            }
        }
    }

    private XComponent loadDocument(OfficeContext context, File inputFile) throws OfficeException {
        if (!inputFile.exists()) {
            throw new OfficeException("input document not found");
        }
        XComponentLoader loader = OfficeUtils.cast(XComponentLoader.class, context.getService("com.sun.star.frame.Desktop"));
        Map<String, ?> loadProperties = this.getLoadProperties(inputFile);
        XComponent document = null;
        try {
            document = loader.loadComponentFromURL(OfficeUtils.toUrl(inputFile), "_blank", 0, OfficeUtils.toUnoProperties(loadProperties));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OfficeException("could not load document: " + inputFile.getName(), illegalArgumentException);
        }
        catch (ErrorCodeIOException errorCodeIOException) {
            throw new OfficeException("could not load document: " + inputFile.getName() + "; errorCode: " + errorCodeIOException.ErrCode, errorCodeIOException);
        }
        catch (IOException ioException) {
            throw new OfficeException("could not load document: " + inputFile.getName(), ioException);
        }
        if (document == null) {
            throw new OfficeException("could not load document: " + inputFile.getName());
        }
        XRefreshable refreshable = OfficeUtils.cast(XRefreshable.class, document);
        if (refreshable != null) {
            refreshable.refresh();
        }
        return document;
    }

    private void processDocument(XComponent document, OfficeContext context) {
        if (OfficeUtils.cast(XServiceInfo.class, document).supportsService("com.sun.star.text.GenericTextDocument")) {
            this.embedWriterImages(document, context);
        }
    }

    private void embedWriterImages(XComponent document, OfficeContext context) {
        XIndexAccess indexAccess = OfficeUtils.cast(XIndexAccess.class, OfficeUtils.cast(XTextGraphicObjectsSupplier.class, document).getGraphicObjects());
        XGraphicProvider graphicProvider = OfficeUtils.cast(XGraphicProvider.class, context.getService("com.sun.star.graphic.GraphicProvider"));
        PropertyValue[] queryProperties = new PropertyValue[]{new PropertyValue()};
        queryProperties[0].Name = "URL";
        for (int i = 0; i < indexAccess.getCount(); ++i) {
            try {
                XPropertySet graphicProperties = OfficeUtils.cast(XPropertySet.class, indexAccess.getByIndex(i));
                String graphicURL = (String)graphicProperties.getPropertyValue("GraphicURL");
                if (graphicURL.contains("vnd.sun.star.GraphicObject")) continue;
                queryProperties[0].Value = graphicURL;
                Size specifiedSize = OfficeUtils.cast(Size.class, graphicProperties.getPropertyValue("ActualSize"));
                graphicProperties.setPropertyValue("Graphic", (Object)graphicProvider.queryGraphic(queryProperties));
                this.adjustImageSize(graphicProperties, specifiedSize);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void adjustImageSize(XPropertySet graphicProperties, Size specifiedSize) {
        try {
            Size size = OfficeUtils.cast(Size.class, graphicProperties.getPropertyValue("ActualSize"));
            if (specifiedSize.Width == 0 && specifiedSize.Height == 0) {
                specifiedSize.Width = size.Width;
                specifiedSize.Height = size.Height;
            } else if (specifiedSize.Width == 0) {
                specifiedSize.Width = specifiedSize.Height * size.Width / size.Height;
            } else if (specifiedSize.Height == 0) {
                specifiedSize.Height = specifiedSize.Width * size.Height / size.Width;
            }
            graphicProperties.setPropertyValue("Size", (Object)specifiedSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void storeDocument(XComponent document, File outputFile) throws OfficeException {
        Map<String, ?> storeProperties = this.getStoreProperties(outputFile, document);
        if (storeProperties == null) {
            throw new OfficeException("unsupported conversion");
        }
        try {
            OfficeUtils.cast(XStorable.class, document).storeToURL(OfficeUtils.toUrl(outputFile), OfficeUtils.toUnoProperties(storeProperties));
        }
        catch (ErrorCodeIOException errorCodeIOException) {
            throw new OfficeException("could not store document: " + outputFile.getName() + "; errorCode: " + errorCodeIOException.ErrCode, errorCodeIOException);
        }
        catch (IOException ioException) {
            throw new OfficeException("could not store document: " + outputFile.getName(), ioException);
        }
    }
}

