/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import java.net.ConnectException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.artofsolving.jodconverter.office.ManagedOfficeProcessSettings;
import org.artofsolving.jodconverter.office.NamedThreadFactory;
import org.artofsolving.jodconverter.office.OfficeConnection;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeProcess;
import org.artofsolving.jodconverter.office.OfficeUtils;
import org.artofsolving.jodconverter.office.RetryTimeoutException;
import org.artofsolving.jodconverter.office.Retryable;
import org.artofsolving.jodconverter.office.TemporaryException;

class ManagedOfficeProcess {
    private static final Integer EXIT_CODE_NEW_INSTALLATION = 81;
    private final ManagedOfficeProcessSettings settings;
    private final OfficeProcess process;
    private final OfficeConnection connection;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("OfficeProcessThread"));
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public ManagedOfficeProcess(ManagedOfficeProcessSettings settings) throws OfficeException {
        this.settings = settings;
        this.process = new OfficeProcess(settings.getOfficeHome(), settings.getUnoUrl(), settings.getRunAsArgs(), settings.getTemplateProfileDir(), settings.getWorkDir(), settings.getProcessManager());
        this.connection = new OfficeConnection(settings.getUnoUrl());
    }

    public OfficeConnection getConnection() {
        return this.connection;
    }

    public void startAndWait() throws OfficeException {
        Future<?> future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ManagedOfficeProcess.this.doStartProcessAndConnect();
            }
        });
        try {
            future.get();
        }
        catch (Exception exception) {
            throw new OfficeException("failed to start and connect", exception);
        }
    }

    public void stopAndWait() throws OfficeException {
        Future<?> future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ManagedOfficeProcess.this.doStopProcess();
            }
        });
        try {
            future.get();
        }
        catch (Exception exception) {
            throw new OfficeException("failed to start and connect", exception);
        }
    }

    public void restartAndWait() {
        Future<?> future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ManagedOfficeProcess.this.doStopProcess();
                ManagedOfficeProcess.this.doStartProcessAndConnect();
            }
        });
        try {
            future.get();
        }
        catch (Exception exception) {
            throw new OfficeException("failed to restart", exception);
        }
    }

    public void restartDueToTaskTimeout() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ManagedOfficeProcess.this.doTerminateProcess();
            }
        });
    }

    public void restartDueToLostConnection() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ManagedOfficeProcess.this.doEnsureProcessExited();
                    ManagedOfficeProcess.this.doStartProcessAndConnect();
                }
                catch (OfficeException officeException) {
                    ManagedOfficeProcess.this.logger.log(Level.SEVERE, "could not restart process", officeException);
                }
            }
        });
    }

    private void doStartProcessAndConnect() throws OfficeException {
        try {
            this.process.start();
            new Retryable(){

                @Override
                protected void attempt() throws TemporaryException, Exception {
                    try {
                        ManagedOfficeProcess.this.connection.connect();
                    }
                    catch (ConnectException connectException) {
                        Integer exitCode = ManagedOfficeProcess.this.process.getExitCode();
                        if (exitCode == null) {
                            throw new TemporaryException(connectException);
                        }
                        if (exitCode.equals(EXIT_CODE_NEW_INSTALLATION)) {
                            ManagedOfficeProcess.this.logger.log(Level.WARNING, "office process died with exit code 81; restarting it");
                            ManagedOfficeProcess.this.process.start(true);
                            throw new TemporaryException(connectException);
                        }
                        throw new OfficeException("office process died with exit code " + exitCode);
                    }
                }
            }.execute(this.settings.getRetryInterval(), this.settings.getRetryTimeout());
        }
        catch (Exception exception) {
            throw new OfficeException("could not establish connection", exception);
        }
    }

    private void doStopProcess() {
        try {
            XDesktop desktop = OfficeUtils.cast(XDesktop.class, this.connection.getService("com.sun.star.frame.Desktop"));
            desktop.terminate();
        }
        catch (DisposedException disposedException) {
        }
        catch (Exception exception) {
            this.doTerminateProcess();
        }
        this.doEnsureProcessExited();
    }

    private void doEnsureProcessExited() throws OfficeException {
        try {
            int exitCode = this.process.getExitCode(this.settings.getRetryInterval(), this.settings.getRetryTimeout());
            this.logger.info("process exited with code " + exitCode);
        }
        catch (RetryTimeoutException retryTimeoutException) {
            this.doTerminateProcess();
        }
        this.process.deleteProfileDir();
    }

    private void doTerminateProcess() throws OfficeException {
        try {
            int exitCode = this.process.forciblyTerminate(this.settings.getRetryInterval(), this.settings.getRetryTimeout());
            this.logger.info("process forcibly terminated with code " + exitCode);
        }
        catch (Exception exception) {
            throw new OfficeException("could not terminate process", exception);
        }
    }
}

