/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.artofsolving.jodconverter.filter;

import org.artofsolving.jodconverter.office.OfficeContext;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeUtils;

import com.sun.star.lang.XComponent;
import com.sun.star.util.XRefreshable;

/**
 * Refreshes the documents that support this operation.
 * 
 * @version $Id: a73f5b8470cb1b3ab6a7faef7fd5b62c11454899 $
 * @since 3.1-xwiki
 */
public class RefreshFilter implements OfficeDocumentFilter
{
    @Override
    public void filter(XComponent document, OfficeContext context) throws OfficeException
    {
        XRefreshable refreshable = OfficeUtils.cast(XRefreshable.class, document);
        if (refreshable != null) {
            refreshable.refresh();
        }
    }
}
