/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter;

import com.sun.star.lang.XComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.artofsolving.jodconverter.AbstractConversionTask;
import org.artofsolving.jodconverter.OfficeDocumentUtils;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.artofsolving.jodconverter.filter.OfficeDocumentFilter;
import org.artofsolving.jodconverter.office.OfficeContext;
import org.artofsolving.jodconverter.office.OfficeException;

public class StandardConversionTask
extends AbstractConversionTask {
    private final DocumentFormat outputFormat;
    private final List<OfficeDocumentFilter> filters = new ArrayList<OfficeDocumentFilter>();
    private Map<String, ?> defaultLoadProperties;
    private DocumentFormat inputFormat;

    public StandardConversionTask(File inputFile, File outputFile, DocumentFormat outputFormat) {
        super(inputFile, outputFile);
        this.outputFormat = outputFormat;
    }

    public void setDefaultLoadProperties(Map<String, ?> defaultLoadProperties) {
        this.defaultLoadProperties = defaultLoadProperties;
    }

    public void setInputFormat(DocumentFormat inputFormat) {
        this.inputFormat = inputFormat;
    }

    public List<OfficeDocumentFilter> getFilters() {
        return this.filters;
    }

    @Override
    protected void modifyDocument(XComponent document, OfficeContext context) throws OfficeException {
        for (OfficeDocumentFilter filter : this.filters) {
            filter.filter(document, context);
        }
    }

    @Override
    protected Map<String, ?> getLoadProperties(File inputFile) {
        HashMap loadProperties = new HashMap();
        if (this.defaultLoadProperties != null) {
            loadProperties.putAll(this.defaultLoadProperties);
        }
        if (this.inputFormat != null && this.inputFormat.getLoadProperties() != null) {
            loadProperties.putAll(this.inputFormat.getLoadProperties());
        }
        return loadProperties;
    }

    @Override
    protected Map<String, ?> getStoreProperties(File outputFile, XComponent document) {
        DocumentFamily family = OfficeDocumentUtils.getDocumentFamily(document);
        return this.outputFormat.getStoreProperties(family);
    }
}

