/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.util.Map;
import org.artofsolving.jodconverter.util.PlatformUtils;

public class OfficeUtils {
    public static final String SERVICE_DESKTOP = "com.sun.star.frame.Desktop";

    private OfficeUtils() {
        throw new AssertionError((Object)"utility class must not be instantiated");
    }

    public static <T> T cast(Class<T> type, Object object) {
        return (T)UnoRuntime.queryInterface(type, (Object)object);
    }

    public static PropertyValue property(String name, Object value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = name;
        propertyValue.Value = value;
        return propertyValue;
    }

    public static PropertyValue[] toUnoProperties(Map<String, ?> properties) {
        PropertyValue[] propertyValues = new PropertyValue[properties.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map subProperties = (Map)value;
                value = OfficeUtils.toUnoProperties(subProperties);
            }
            propertyValues[i++] = OfficeUtils.property(entry.getKey(), value);
        }
        return propertyValues;
    }

    public static String toUrl(File file) {
        String path = file.toURI().getRawPath();
        String url = path.startsWith("//") ? "file:" + path : "file://" + path;
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public static File getDefaultOfficeHome() {
        if (System.getProperty("office.home") != null) {
            return new File(System.getProperty("office.home"));
        }
        if (PlatformUtils.isWindows()) {
            String programFiles = System.getenv("ProgramFiles(x86)");
            if (programFiles == null) {
                programFiles = System.getenv("ProgramFiles");
            }
            return OfficeUtils.findOfficeHome(programFiles + File.separator + "OpenOffice.org 3", programFiles + File.separator + "LibreOffice 3");
        }
        if (PlatformUtils.isMac()) {
            return OfficeUtils.findOfficeHome("/Applications/OpenOffice.org.app/Contents", "/Applications/LibreOffice.app/Contents");
        }
        return OfficeUtils.findOfficeHome("/opt/openoffice.org3", "/opt/libreoffice", "/usr/lib64/openoffice", "/usr/lib64/openoffice.org3", "/usr/lib64/openoffice.org", "/usr/lib64/libreoffice", "/usr/lib/openoffice", "/usr/lib/openoffice.org3", "/usr/lib/openoffice.org", "/usr/lib/libreoffice");
    }

    private static File findOfficeHome(String ... knownPaths) {
        for (String path : knownPaths) {
            File home = new File(path);
            if (!OfficeUtils.getOfficeExecutable(home).isFile()) continue;
            return home;
        }
        return null;
    }

    public static File getOfficeExecutable(File officeHome) {
        if (PlatformUtils.isMac()) {
            File executableFile = new File(officeHome, "MacOS/soffice.bin");
            if (!executableFile.isFile()) {
                executableFile = new File(officeHome, "program/soffice");
            }
            return executableFile;
        }
        if (PlatformUtils.isWindows()) {
            return new File(officeHome, "program/soffice.exe");
        }
        return new File(officeHome, "program/soffice.bin");
    }
}

