/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.io.File;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.log.LogRecord;

final class CapturedLogRecord
extends LogRecord {
    private final File sourceFile;

    CapturedLogRecord(LogRecord record, File sourceFile) {
        super(record.getSeverity(), record.getCursor(), record.getMessage(), record.getSourceFileName(), record.getSourceMethodName());
        this.sourceFile = sourceFile;
    }

    public Cursor getCursor() {
        if (super.getCursor() != null) {
            return super.getCursor();
        }
        if (this.sourceFile != null) {
            return new FileCursor(this.sourceFile);
        }
        return null;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    class FileCursor
    implements Cursor {
        private final File file;

        public FileCursor(File file) {
            this.file = file;
        }

        public int getLineNumber() {
            return 0;
        }

        public String getPath() {
            return this.file.getName();
        }

        public String getDir() {
            return this.file.getParent();
        }

        public String getFile() {
            return this.file.getAbsolutePath();
        }
    }
}

