/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.asciidoctor.maven.log.FailIf;
import org.asciidoctor.maven.log.LogHandler;
import org.asciidoctor.maven.log.LogRecordFormatter;
import org.asciidoctor.maven.log.MemoryLogHandler;

public class LogRecordsProcessors {
    private final LogHandler logHandler;
    private final File sourceDirectory;
    private final Consumer<String> errorMessageConsumer;

    public LogRecordsProcessors(LogHandler logHandler, File sourceDirectory, Consumer<String> errorMessageConsumer) {
        this.logHandler = logHandler;
        this.sourceDirectory = sourceDirectory;
        this.errorMessageConsumer = errorMessageConsumer;
    }

    public void processLogRecords(MemoryLogHandler memoryLogHandler) throws Exception {
        String textToSearch;
        Severity severity;
        List<LogRecord> records;
        if ((this.logHandler.isSeveritySet() || this.logHandler.isContainsTextNotBlank()) && (records = memoryLogHandler.filter(severity = (Severity)Optional.ofNullable(this.logHandler.getFailIf()).map(FailIf::getSeverity).orElse(null), textToSearch = (String)Optional.ofNullable(this.logHandler.getFailIf()).map(FailIf::getContainsText).orElse(null))).size() > 0) {
            for (LogRecord record : records) {
                this.errorMessageConsumer.accept(LogRecordFormatter.format(record, this.sourceDirectory));
            }
            throw new Exception(this.getMessage(records, severity, textToSearch));
        }
    }

    private String getMessage(List<LogRecord> records, Severity severity, String textToSearch) {
        if (this.logHandler.isSeveritySet() && this.logHandler.isContainsTextNotBlank()) {
            return String.format("Found %s issue(s) matching severity %s or higher and text '%s'", records.size(), severity, textToSearch);
        }
        if (this.logHandler.isSeveritySet()) {
            return String.format("Found %s issue(s) of severity %s or higher during conversion", records.size(), severity);
        }
        return String.format("Found %s issue(s) containing '%s'", records.size(), textToSearch);
    }
}

