/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

public class AsciidoctorFileScanner {
    public static String[] DEFAULT_FILE_EXTENSIONS = new String[]{"**/*.adoc", "**/*.ad", "**/*.asc", "**/*.asciidoc"};
    public static String[] IGNORED_FOLDERS_AND_FILES = new String[]{"**/_*.*", "**/_*", "**/_*/**/*.*", "**/docinfo.html", "**/docinfo-header.html", "**/docinfo-footer.html", "**/*-docinfo.html", "**/*-docinfo-header.html", "**/*-docinfo-footer.html", "**/docinfo.xml", "**/docinfo-header.xml", "**/docinfo-footer.xml", "**/*-docinfo.xml", "**/*-docinfo-header.xml", "**/*-docinfo-footer.xml"};
    private BuildContext buildContext;

    public AsciidoctorFileScanner(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public List<File> scan(Resource resource) {
        Scanner scanner = this.buildContext.newScanner(new File(resource.getDirectory()), true);
        this.setupScanner(scanner, resource);
        scanner.scan();
        ArrayList<File> files = new ArrayList<File>();
        for (String file : scanner.getIncludedFiles()) {
            files.add(new File(resource.getDirectory(), file));
        }
        return files;
    }

    public List<File> scan(List<Resource> resources) {
        ArrayList<File> files = new ArrayList<File>();
        for (Resource resource : resources) {
            files.addAll(this.scan(resource));
        }
        return files;
    }

    private void setupScanner(Scanner scanner, Resource resource) {
        if (resource.getIncludes() == null || resource.getIncludes().isEmpty()) {
            scanner.setIncludes(DEFAULT_FILE_EXTENSIONS);
        } else {
            scanner.setIncludes(resource.getIncludes().toArray(new String[0]));
        }
        if (resource.getExcludes() == null || resource.getExcludes().isEmpty()) {
            scanner.setExcludes(IGNORED_FOLDERS_AND_FILES);
        } else {
            scanner.setExcludes(this.mergeAndConvert(resource.getExcludes(), IGNORED_FOLDERS_AND_FILES));
        }
        scanner.addDefaultExcludes();
    }

    private String[] mergeAndConvert(List<String> list, String[] array) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(array));
        set.addAll(list);
        return set.toArray(new String[set.size()]);
    }
}

