/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.AnnotationDefault;
import org.aspectj.apache.bcel.classfile.BootstrapMethods;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.Deprecated;
import org.aspectj.apache.bcel.classfile.EnclosingMethod;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.InnerClasses;
import org.aspectj.apache.bcel.classfile.LineNumberTable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.LocalVariableTypeTable;
import org.aspectj.apache.bcel.classfile.MethodParameters;
import org.aspectj.apache.bcel.classfile.Node;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.SourceFile;
import org.aspectj.apache.bcel.classfile.StackMap;
import org.aspectj.apache.bcel.classfile.Synthetic;
import org.aspectj.apache.bcel.classfile.Unknown;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisTypeAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisTypeAnnos;

public abstract class Attribute
implements Cloneable,
Node,
Serializable {
    public static final Attribute[] NoAttributes = new Attribute[0];
    protected byte tag;
    protected int nameIndex;
    protected int length;
    protected ConstantPool cpool;

    protected Attribute(byte by, int n, int n2, ConstantPool constantPool) {
        this.tag = by;
        this.nameIndex = n;
        this.length = n2;
        this.cpool = constantPool;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeInt(this.length);
    }

    public static final Attribute readAttribute(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = -1;
        int n2 = dataInputStream.readUnsignedShort();
        String string = constantPool.getConstantUtf8(n2).getValue();
        int n3 = dataInputStream.readInt();
        for (int n4 = 0; n4 < 23; n4 = (int)((byte)(n4 + 1))) {
            if (!string.equals(Constants.ATTRIBUTE_NAMES[n4])) continue;
            n = n4;
            break;
        }
        switch (n) {
            case -1: {
                return new Unknown(n2, n3, dataInputStream, constantPool);
            }
            case 1: {
                return new ConstantValue(n2, n3, dataInputStream, constantPool);
            }
            case 0: {
                return new SourceFile(n2, n3, dataInputStream, constantPool);
            }
            case 2: {
                return new Code(n2, n3, dataInputStream, constantPool);
            }
            case 3: {
                return new ExceptionTable(n2, n3, dataInputStream, constantPool);
            }
            case 4: {
                return new LineNumberTable(n2, n3, dataInputStream, constantPool);
            }
            case 5: {
                return new LocalVariableTable(n2, n3, dataInputStream, constantPool);
            }
            case 6: {
                return new InnerClasses(n2, n3, dataInputStream, constantPool);
            }
            case 7: {
                return new Synthetic(n2, n3, dataInputStream, constantPool);
            }
            case 8: {
                return new Deprecated(n2, n3, dataInputStream, constantPool);
            }
            case 10: {
                return new Signature(n2, n3, dataInputStream, constantPool);
            }
            case 11: {
                return new StackMap(n2, n3, dataInputStream, constantPool);
            }
            case 12: {
                return new RuntimeVisAnnos(n2, n3, dataInputStream, constantPool);
            }
            case 13: {
                return new RuntimeInvisAnnos(n2, n3, dataInputStream, constantPool);
            }
            case 14: {
                return new RuntimeVisParamAnnos(n2, n3, dataInputStream, constantPool);
            }
            case 15: {
                return new RuntimeInvisParamAnnos(n2, n3, dataInputStream, constantPool);
            }
            case 18: {
                return new AnnotationDefault(n2, n3, dataInputStream, constantPool);
            }
            case 16: {
                return new LocalVariableTypeTable(n2, n3, dataInputStream, constantPool);
            }
            case 17: {
                return new EnclosingMethod(n2, n3, dataInputStream, constantPool);
            }
            case 19: {
                return new BootstrapMethods(n2, n3, dataInputStream, constantPool);
            }
            case 20: {
                return new RuntimeVisTypeAnnos(n2, n3, dataInputStream, constantPool);
            }
            case 21: {
                return new RuntimeInvisTypeAnnos(n2, n3, dataInputStream, constantPool);
            }
            case 22: {
                return new MethodParameters(n2, n3, dataInputStream, constantPool);
            }
        }
        throw new IllegalStateException();
    }

    public String getName() {
        return this.cpool.getConstantUtf8(this.nameIndex).getValue();
    }

    public final int getLength() {
        return this.length;
    }

    public final int getNameIndex() {
        return this.nameIndex;
    }

    public final byte getTag() {
        return this.tag;
    }

    public final ConstantPool getConstantPool() {
        return this.cpool;
    }

    public String toString() {
        return Constants.ATTRIBUTE_NAMES[this.tag];
    }

    @Override
    public abstract void accept(ClassVisitor var1);
}

