/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import com.google.common.base.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.assertions.generator.util.ClassUtil;

public class TypeName
implements Comparable<TypeName> {
    private static final String CAPITAL_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String BOOLEAN = "boolean";
    private static final String NO_PACKAGE = "";
    public static final String JAVA_LANG_PACKAGE = "java.lang";
    protected static final String[] PRIMITIVE_TYPES = new String[]{"int", "long", "short", "byte", "float", "double", "char", "boolean"};
    protected static final String[] REAL_NUMBERS_TYPES = new String[]{"float", "double"};
    protected static final String[] REAL_NUMBERS_WRAPPER_TYPES = new String[]{"Float", "Double"};
    private String typeSimpleName;
    private String typeSimpleNameWithOuterClass;
    private String typeSimpleNameWithOuterClassNotSeparatedByDots;
    private String packageName;

    public TypeName(String typeSimpleName, String packageName) {
        if (typeSimpleName == null) {
            throw new IllegalArgumentException("type simple name should not be null");
        }
        this.typeSimpleName = typeSimpleName;
        this.typeSimpleNameWithOuterClass = typeSimpleName;
        this.typeSimpleNameWithOuterClassNotSeparatedByDots = typeSimpleName;
        this.setPackageName(packageName);
    }

    public TypeName(String typeName) {
        if (StringUtils.isBlank((CharSequence)typeName)) {
            throw new IllegalArgumentException("type name should not be blank or null");
        }
        int indexOfClassName = StringUtils.indexOfAny((CharSequence)typeName, (String)CAPITAL_LETTERS);
        if (indexOfClassName > 0) {
            this.typeSimpleNameWithOuterClass = typeName.substring(indexOfClassName);
            this.setPackageName(StringUtils.remove((String)typeName, (String)("." + this.typeSimpleNameWithOuterClass)));
        } else {
            this.typeSimpleNameWithOuterClass = typeName;
            this.setPackageName(NO_PACKAGE);
        }
        this.typeSimpleName = this.typeSimpleNameWithOuterClass.contains(".") ? StringUtils.substringAfterLast((String)this.typeSimpleNameWithOuterClass, (String)".") : this.typeSimpleNameWithOuterClass;
        this.typeSimpleNameWithOuterClassNotSeparatedByDots = StringUtils.remove((String)this.typeSimpleNameWithOuterClass, (String)".");
    }

    public TypeName(Class<?> clazz) {
        this.typeSimpleName = clazz.getSimpleName();
        this.typeSimpleNameWithOuterClass = ClassUtil.getSimpleNameWithOuterClass(clazz);
        this.typeSimpleNameWithOuterClassNotSeparatedByDots = ClassUtil.getSimpleNameWithOuterClassNotSeparatedByDots(clazz);
        this.packageName = clazz.getPackage() == null ? NO_PACKAGE : clazz.getPackage().getName();
    }

    public String getSimpleName() {
        return this.typeSimpleName;
    }

    public String getSimpleNameWithOuterClass() {
        return this.typeSimpleNameWithOuterClass;
    }

    public String getSimpleNameWithOuterClassNotSeparatedByDots() {
        return this.typeSimpleNameWithOuterClassNotSeparatedByDots;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private void setPackageName(String packageName) {
        this.packageName = packageName == null ? NO_PACKAGE : packageName;
    }

    public boolean isPrimitive() {
        return ArrayUtils.contains((Object[])PRIMITIVE_TYPES, (Object)this.typeSimpleName) && StringUtils.isEmpty((CharSequence)this.packageName);
    }

    public boolean isRealNumber() {
        return this.isPrimitiveRealNumber() || this.isRealNumberWrapper();
    }

    private boolean isPrimitiveRealNumber() {
        return ArrayUtils.contains((Object[])REAL_NUMBERS_TYPES, (Object)this.typeSimpleName) && StringUtils.isEmpty((CharSequence)this.packageName);
    }

    private boolean isRealNumberWrapper() {
        return ArrayUtils.contains((Object[])REAL_NUMBERS_WRAPPER_TYPES, (Object)this.typeSimpleName) && JAVA_LANG_PACKAGE.equals(this.packageName);
    }

    public boolean isBoolean() {
        return BOOLEAN.equals(this.typeSimpleName) && StringUtils.isEmpty((CharSequence)this.packageName);
    }

    public boolean belongsToJavaLangPackage() {
        return JAVA_LANG_PACKAGE.equals(this.packageName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.typeSimpleName == null ? 0 : this.typeSimpleName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeName other = (TypeName)obj;
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        return !(this.typeSimpleName == null ? other.typeSimpleName != null : !this.typeSimpleName.equals(other.typeSimpleName));
    }

    public String toString() {
        return this.getFullyQualifiedClassName();
    }

    @Override
    public int compareTo(TypeName o) {
        return this.getFullyQualifiedClassName().compareTo(o.getFullyQualifiedClassName());
    }

    public boolean isArray() {
        return this.typeSimpleName.contains("[]");
    }

    public boolean isNested() {
        return this.typeSimpleNameWithOuterClass.contains(".");
    }

    public TypeName getOuterClassTypeName() {
        if (!this.isNested()) {
            return null;
        }
        return new TypeName(StringUtils.substringBefore((String)this.typeSimpleNameWithOuterClass, (String)"."), this.packageName);
    }

    public String getFullyQualifiedClassName() {
        return StringUtils.isEmpty((CharSequence)this.packageName) ? this.typeSimpleNameWithOuterClass : this.packageName + "." + this.typeSimpleNameWithOuterClass;
    }

    public String getFullyQualifiedTypeNameIfNeeded(String targetPackage) {
        return this.belongsToJavaLangPackage() || Objects.equal((Object)targetPackage, (Object)this.packageName) ? this.getSimpleNameWithOuterClass() : this.getFullyQualifiedClassName();
    }
}

