/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Method;
import java.util.List;
import org.assertj.core.api.ErrorCollector;
import org.assertj.core.api.ProxifyExtractingResult;
import org.assertj.core.internal.cglib.proxy.Callback;
import org.assertj.core.internal.cglib.proxy.CallbackFilter;
import org.assertj.core.internal.cglib.proxy.Enhancer;
import org.assertj.core.util.Arrays;

class SoftProxies {
    private final ErrorCollector collector = new ErrorCollector();

    SoftProxies() {
    }

    List<Throwable> errorsCollected() {
        return this.collector.errors();
    }

    <V, T> V create(Class<V> assertClass, Class<T> actualClass, T actual) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(assertClass);
        enhancer.setCallbackFilter(CollectErrorsOrCreateExtractedProxy.FILTER);
        enhancer.setCallbacks(new Callback[]{this.collector, new ProxifyExtractingResult(this)});
        return (V)enhancer.create(Arrays.array(actualClass), Arrays.array(actual));
    }

    private static enum CollectErrorsOrCreateExtractedProxy implements CallbackFilter
    {
        FILTER;

        private static final int ERROR_COLLECTOR_INDEX = 0;
        private static final int PROXIFY_EXTRACTING_INDEX = 1;

        @Override
        public int accept(Method method) {
            return this.isExtractingMethod(method) ? 1 : 0;
        }

        private boolean isExtractingMethod(Method method) {
            return method.getName().toLowerCase().contains("extracting");
        }
    }
}

