/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Strings;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractCharSequenceAssert<SELF extends AbstractCharSequenceAssert<SELF, ACTUAL>, ACTUAL extends CharSequence>
extends AbstractAssert<SELF, ACTUAL>
implements EnumerableAssert<SELF, Character> {
    @VisibleForTesting
    Strings strings = Strings.instance();

    public AbstractCharSequenceAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.strings.assertNullOrEmpty(this.info, (CharSequence)this.actual);
    }

    @Override
    public void isEmpty() {
        this.strings.assertEmpty(this.info, (CharSequence)this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.strings.assertNotEmpty(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isBlank() {
        this.strings.assertBlank(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isNotBlank() {
        this.strings.assertNotBlank(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsOnlyWhitespaces() {
        this.strings.assertContainsOnlyWhitespaces(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContainOnlyWhitespaces() {
        this.strings.assertDoesNotContainOnlyWhitespaces(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Deprecated
    public SELF isJavaBlank() {
        this.strings.assertJavaBlank(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Deprecated
    public SELF isNotJavaBlank() {
        this.strings.assertNotJavaBlank(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.strings.assertHasSize(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF hasLineCount(int expectedLineCount) {
        this.strings.assertHasLineCount(this.info, (CharSequence)this.actual, expectedLineCount);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF hasSameSizeAs(CharSequence other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (CharSequence)this.actual, other);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (CharSequence)this.actual, other);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (CharSequence)this.actual, other);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToIgnoringCase(CharSequence expected) {
        this.strings.assertEqualsIgnoringCase(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isNotEqualToIgnoringCase(CharSequence expected) {
        this.strings.assertNotEqualsIgnoringCase(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsOnlyDigits() {
        this.strings.assertContainsOnlyDigits(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsOnlyOnce(CharSequence sequence) {
        this.strings.assertContainsOnlyOnce(this.info, (CharSequence)this.actual, sequence);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF contains(CharSequence ... values) {
        this.strings.assertContains(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF contains(Iterable<? extends CharSequence> values) {
        this.strings.assertContains(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsSequence(CharSequence ... values) {
        this.strings.assertContainsSequence(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsSequence(Iterable<? extends CharSequence> values) {
        this.strings.assertContainsSequence(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsSubsequence(CharSequence ... values) {
        this.strings.assertContainsSubsequence(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsSubsequence(Iterable<? extends CharSequence> values) {
        this.strings.assertContainsSubsequence(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsIgnoringCase(CharSequence sequence) {
        this.strings.assertContainsIgnoringCase(this.info, (CharSequence)this.actual, sequence);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContain(CharSequence ... values) {
        this.strings.assertDoesNotContain(this.info, (CharSequence)this.actual, values);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContain(Iterable<? extends CharSequence> values) {
        this.strings.assertDoesNotContain(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContainPattern(CharSequence pattern) {
        this.strings.assertDoesNotContainPattern((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotContainPattern(Pattern pattern) {
        this.strings.assertDoesNotContainPattern((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF startsWith(CharSequence prefix) {
        this.strings.assertStartsWith(this.info, (CharSequence)this.actual, prefix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotStartWith(CharSequence prefix) {
        this.strings.assertDoesNotStartWith(this.info, (CharSequence)this.actual, prefix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF endsWith(CharSequence suffix) {
        this.strings.assertEndsWith(this.info, (CharSequence)this.actual, suffix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotEndWith(CharSequence suffix) {
        this.strings.assertDoesNotEndWith(this.info, (CharSequence)this.actual, suffix);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF matches(CharSequence regex) {
        this.strings.assertMatches((AssertionInfo)this.info, (CharSequence)this.actual, regex);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotMatch(CharSequence regex) {
        this.strings.assertDoesNotMatch((AssertionInfo)this.info, (CharSequence)this.actual, regex);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF matches(Pattern pattern) {
        this.strings.assertMatches((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF doesNotMatch(Pattern pattern) {
        this.strings.assertDoesNotMatch((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isXmlEqualTo(CharSequence expectedXml) {
        this.strings.assertXmlEqualsTo(this.info, (CharSequence)this.actual, expectedXml);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isXmlEqualToContentOf(File xmlFile) {
        this.isXmlEqualTo(Assertions.contentOf(xmlFile));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    @Deprecated
    public final SELF usingElementComparator(Comparator<? super Character> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for CharSequence comparison");
    }

    @Override
    @Deprecated
    public final SELF usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for CharSequence comparison");
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator, String customComparatorDescription) {
        super.usingComparator((Comparator)customComparator, customComparatorDescription);
        this.strings = new Strings(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        super.usingDefaultComparator();
        this.strings = Strings.instance();
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF inHexadecimal() {
        return (SELF)((AbstractCharSequenceAssert)super.inHexadecimal());
    }

    @CheckReturnValue
    public SELF inUnicode() {
        this.info.useUnicodeRepresentation();
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToIgnoringWhitespace(CharSequence expected) {
        this.strings.assertEqualsIgnoringWhitespace(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isNotEqualToIgnoringWhitespace(CharSequence expected) {
        this.strings.assertNotEqualsIgnoringWhitespace(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToNormalizingWhitespace(CharSequence expected) {
        this.strings.assertEqualsNormalizingWhitespace(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isNotEqualToNormalizingWhitespace(CharSequence expected) {
        this.strings.assertNotEqualsNormalizingWhitespace(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isSubstringOf(CharSequence sequence) {
        this.strings.assertIsSubstringOf(this.info, (CharSequence)this.actual, sequence);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsPattern(CharSequence regex) {
        this.strings.assertContainsPattern((AssertionInfo)this.info, (CharSequence)this.actual, regex);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF containsPattern(Pattern pattern) {
        this.strings.assertContainsPattern((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToNormalizingNewlines(CharSequence expected) {
        this.strings.assertIsEqualToNormalizingNewlines(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isEqualToIgnoringNewLines(CharSequence expected) {
        this.strings.assertIsEqualToIgnoringNewLines(this.info, (CharSequence)this.actual, expected);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isLowerCase() {
        this.strings.assertLowerCase(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }

    public SELF isUpperCase() {
        this.strings.assertUpperCase(this.info, (CharSequence)this.actual);
        return (SELF)((AbstractCharSequenceAssert)this.myself);
    }
}

