/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Strings;

final class DualValue {
    static final Class<?>[] DEFAULT_ORDERED_COLLECTION_TYPES = Arrays.array(List.class, SortedSet.class, LinkedHashSet.class);
    final List<String> path;
    final String concatenatedPath;
    final Object actual;
    final Object expected;
    private final int hashCode;

    DualValue(List<String> path, Object actual, Object expected) {
        this.path = Lists.newArrayList(path);
        this.concatenatedPath = Strings.join(path).with(".");
        this.actual = actual;
        this.expected = expected;
        int h1 = actual != null ? actual.hashCode() : 0;
        int h2 = expected != null ? expected.hashCode() : 0;
        this.hashCode = h1 + h2;
    }

    DualValue(List<String> parentPath, String fieldName, Object actual, Object expected) {
        this(DualValue.fiedlPath(parentPath, fieldName), actual, expected);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DualValue)) {
            return false;
        }
        DualValue that = (DualValue)other;
        return this.actual == that.actual && this.expected == that.expected;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.format("DualValue [path=%s, actual=%s, expected=%s]", this.concatenatedPath, this.actual, this.expected);
    }

    public List<String> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    public String getConcatenatedPath() {
        return this.concatenatedPath;
    }

    public String getFieldName() {
        if (this.path.isEmpty()) {
            return "";
        }
        return this.path.get(this.path.size() - 1);
    }

    public boolean isJavaType() {
        if (this.actual == null) {
            return false;
        }
        return this.actual.getClass().getName().startsWith("java.");
    }

    public boolean isExpectedFieldAnArray() {
        return Arrays.isArray(this.expected);
    }

    public boolean isActualFieldAnArray() {
        return Arrays.isArray(this.actual);
    }

    public boolean isActualFieldAnOptional() {
        return this.actual instanceof Optional;
    }

    public boolean isActualFieldAnOptionalInt() {
        return this.actual instanceof OptionalInt;
    }

    public boolean isActualFieldAnOptionalLong() {
        return this.actual instanceof OptionalLong;
    }

    public boolean isActualFieldAnOptionalDouble() {
        return this.actual instanceof OptionalDouble;
    }

    public boolean isActualFieldAnEmptyOptionalOfAnyType() {
        return this.isActualFieldAnEmptyOptional() || this.isActualFieldAnEmptyOptionalInt() || this.isActualFieldAnEmptyOptionalLong() || this.isActualFieldAnEmptyOptionalDouble();
    }

    private boolean isActualFieldAnEmptyOptional() {
        return this.isActualFieldAnOptional() && !((Optional)this.actual).isPresent();
    }

    private boolean isActualFieldAnEmptyOptionalInt() {
        return this.isActualFieldAnOptionalInt() && !((OptionalInt)this.actual).isPresent();
    }

    private boolean isActualFieldAnEmptyOptionalLong() {
        return this.isActualFieldAnOptionalLong() && !((OptionalLong)this.actual).isPresent();
    }

    private boolean isActualFieldAnEmptyOptionalDouble() {
        return this.isActualFieldAnOptionalDouble() && !((OptionalDouble)this.actual).isPresent();
    }

    public boolean isExpectedFieldAnOptional() {
        return this.expected instanceof Optional;
    }

    public boolean isActualFieldAMap() {
        return this.actual instanceof Map;
    }

    public boolean isExpectedFieldAMap() {
        return this.expected instanceof Map;
    }

    public boolean isActualFieldASortedMap() {
        return this.actual instanceof SortedMap;
    }

    public boolean isExpectedFieldASortedMap() {
        return this.expected instanceof SortedMap;
    }

    public boolean isActualFieldAnOrderedCollection() {
        return DualValue.isAnOrderedCollection(this.actual);
    }

    public boolean isExpectedFieldAnOrderedCollection() {
        return DualValue.isAnOrderedCollection(this.expected);
    }

    public boolean isActualFieldAnIterable() {
        return this.actual instanceof Iterable && !(this.actual instanceof Path);
    }

    public boolean isExpectedFieldAnIterable() {
        return this.expected instanceof Iterable && !(this.expected instanceof Path);
    }

    private static boolean isAnOrderedCollection(Object value) {
        return Stream.of(DEFAULT_ORDERED_COLLECTION_TYPES).anyMatch(type -> type.isInstance(value));
    }

    public boolean isEnum() {
        return this.expected.getClass().isEnum();
    }

    public boolean isActualFieldAnEnum() {
        return this.actual.getClass().isEnum();
    }

    public boolean hasNoContainerValues() {
        return !DualValue.isContainer(this.actual) && !DualValue.isContainer(this.expected);
    }

    public boolean hasNoNullValues() {
        return this.actual != null && this.expected != null;
    }

    private static boolean isContainer(Object o) {
        return o instanceof Iterable || o instanceof Map || o instanceof Optional || Arrays.isArray(o);
    }

    private static List<String> fiedlPath(List<String> parentPath, String fieldName) {
        ArrayList<String> fieldPath = Lists.newArrayList(parentPath);
        fieldPath.add(fieldName);
        return fieldPath;
    }

    public boolean hasPotentialCyclingValues() {
        return DualValue.isPotentialCyclingValue(this.actual) && DualValue.isPotentialCyclingValue(this.expected);
    }

    private static boolean isPotentialCyclingValue(Object object) {
        if (object == null) {
            return false;
        }
        return !object.getClass().getCanonicalName().startsWith("java.lang");
    }
}

