/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectAssertFactory;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;

public class ListAssert<ELEMENT>
extends FactoryBasedNavigableListAssert<ListAssert<ELEMENT>, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> {
    public ListAssert(List<? extends ELEMENT> actual) {
        super(actual, ListAssert.class, new ObjectAssertFactory());
    }

    protected ListAssert(Stream<? extends ELEMENT> actual) {
        this(actual == null ? null : new ListFromStream(actual));
    }

    protected ListAssert(IntStream actual) {
        this(actual == null ? null : new ListFromStream<Integer, IntStream>(actual));
    }

    protected ListAssert(LongStream actual) {
        this(actual == null ? null : new ListFromStream<Long, LongStream>(actual));
    }

    protected ListAssert(DoubleStream actual) {
        this(actual == null ? null : new ListFromStream<Double, DoubleStream>(actual));
    }

    @Override
    public ListAssert<ELEMENT> isEqualTo(Object expected) {
        if (this.actual instanceof ListFromStream && this.asListFromStream().stream == expected) {
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isEqualTo(expected);
    }

    @Override
    public ListAssert<ELEMENT> isInstanceOf(Class<?> type) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsInstanceOf(this.info, this.asListFromStream().stream, type);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isInstanceOf((Class)type);
    }

    @Override
    public ListAssert<ELEMENT> isInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsInstanceOfAny(this.info, this.asListFromStream().stream, types);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isInstanceOfAny((Class[])types);
    }

    @Override
    public ListAssert<ELEMENT> isOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsOfAnyClassIn(this.info, this.asListFromStream().stream, types);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isOfAnyClassIn((Class[])types);
    }

    @Override
    public ListAssert<ELEMENT> isExactlyInstanceOf(Class<?> type) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsExactlyInstanceOf(this.info, this.asListFromStream().stream, type);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isExactlyInstanceOf((Class)type);
    }

    @Override
    public ListAssert<ELEMENT> isNotInstanceOf(Class<?> type) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsNotInstanceOf(this.info, this.asListFromStream().stream, type);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isNotInstanceOf((Class)type);
    }

    @Override
    public ListAssert<ELEMENT> isNotInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsNotInstanceOfAny(this.info, this.asListFromStream().stream, types);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isNotInstanceOfAny((Class[])types);
    }

    @Override
    public ListAssert<ELEMENT> isNotOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsNotOfAnyClassIn(this.info, this.asListFromStream().stream, types);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isNotOfAnyClassIn((Class[])types);
    }

    @Override
    public ListAssert<ELEMENT> isNotExactlyInstanceOf(Class<?> type) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsNotExactlyInstanceOf(this.info, this.asListFromStream().stream, type);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isNotExactlyInstanceOf((Class)type);
    }

    @Override
    public ListAssert<ELEMENT> isSameAs(Object expected) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertSame(this.info, this.asListFromStream().stream, expected);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isSameAs(expected);
    }

    @Override
    public ListAssert<ELEMENT> isNotSameAs(Object expected) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertNotSame(this.info, this.asListFromStream().stream, expected);
            return (ListAssert)this.myself;
        }
        return (ListAssert)super.isNotSameAs(expected);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> startsWith(ELEMENT ... sequence) {
        if (!(this.actual instanceof ListFromStream)) {
            return (ListAssert)super.startsWith((Object[])sequence);
        }
        this.objects.assertNotNull(this.info, this.actual);
        CommonValidations.checkIsNotNull(sequence);
        Iterator iterator = this.asListFromStream().stream().iterator();
        if (sequence.length == 0 && iterator.hasNext()) {
            throw new AssertionError((Object)"actual is not empty");
        }
        int i = 0;
        while (iterator.hasNext() && i < sequence.length) {
            if (this.iterables.getComparisonStrategy().areEqual(iterator.next(), sequence[i++])) continue;
            throw this.actualDoesNotStartWithSequence(this.info, sequence);
        }
        if (sequence.length > i) {
            throw this.actualDoesNotStartWithSequence(this.info, sequence);
        }
        return (ListAssert)this.myself;
    }

    private AssertionError actualDoesNotStartWithSequence(AssertionInfo info, Object[] sequence) {
        return Failures.instance().failure(info, ShouldStartWith.shouldStartWith("Stream under test", sequence, this.iterables.getComparisonStrategy()));
    }

    private ListFromStream asListFromStream() {
        return (ListFromStream)this.actual;
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> contains(ELEMENT ... values) {
        return (ListAssert)super.contains((Object[])values);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> containsOnly(ELEMENT ... values) {
        return (ListAssert)super.containsOnly((Object[])values);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> containsOnlyOnce(ELEMENT ... values) {
        return (ListAssert)super.containsOnlyOnce((Object[])values);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> containsExactly(ELEMENT ... values) {
        return (ListAssert)super.containsExactly((Object[])values);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> containsExactlyInAnyOrder(ELEMENT ... values) {
        return (ListAssert)super.containsExactlyInAnyOrder((Object[])values);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> isSubsetOf(ELEMENT ... values) {
        return (ListAssert)super.isSubsetOf((Object[])values);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> containsSequence(ELEMENT ... sequence) {
        return (ListAssert)super.containsSequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> doesNotContainSequence(ELEMENT ... sequence) {
        return (ListAssert)super.doesNotContainSequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> containsSubsequence(ELEMENT ... sequence) {
        return (ListAssert)super.containsSubsequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> doesNotContainSubsequence(ELEMENT ... sequence) {
        return (ListAssert)super.doesNotContainSubsequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> doesNotContain(ELEMENT ... values) {
        return (ListAssert)super.doesNotContain((Object[])values);
    }

    @Override
    @SafeVarargs
    public final ListAssert<ELEMENT> endsWith(ELEMENT first, ELEMENT ... rest) {
        return (ListAssert)super.endsWith((Object)first, (Object[])rest);
    }

    @VisibleForTesting
    static class ListFromStream<ELEMENT, STREAM extends BaseStream<ELEMENT, STREAM>>
    extends AbstractList<ELEMENT> {
        private BaseStream<ELEMENT, STREAM> stream;
        private List<ELEMENT> list;

        public ListFromStream(BaseStream<ELEMENT, STREAM> stream) {
            this.stream = stream;
        }

        @Override
        public Stream<ELEMENT> stream() {
            this.initList();
            return this.list.stream();
        }

        private List<ELEMENT> initList() {
            if (this.list == null) {
                this.list = Lists.newArrayList(this.stream.iterator());
            }
            return this.list;
        }

        @Override
        public int size() {
            this.initList();
            return this.list.size();
        }

        @Override
        public ELEMENT get(int index) {
            this.initList();
            return this.list.get(index);
        }
    }
}

