/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.Circuit;
import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.DirectoryCircuit;
import com.subgraph.orchid.HiddenServiceCircuit;
import com.subgraph.orchid.InternalCircuit;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.circuits.CircuitExtender;
import com.subgraph.orchid.circuits.CircuitImpl;
import com.subgraph.orchid.circuits.CircuitManagerImpl;
import com.subgraph.orchid.circuits.StreamImpl;
import com.subgraph.orchid.circuits.path.CircuitPathChooser;
import com.subgraph.orchid.circuits.path.PathSelectionFailedException;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class InternalCircuitImpl
extends CircuitImpl
implements InternalCircuit,
DirectoryCircuit,
HiddenServiceCircuit {
    private InternalType type = InternalType.UNUSED;
    private boolean ntorEnabled;

    InternalCircuitImpl(CircuitManagerImpl circuitManager, List<Router> prechosenPath) {
        super(circuitManager, prechosenPath);
        this.ntorEnabled = circuitManager.isNtorEnabled();
    }

    protected InternalCircuitImpl(CircuitManagerImpl circuitManager) {
        this(circuitManager, null);
    }

    @Override
    protected List<Router> choosePathForCircuit(CircuitPathChooser pathChooser) throws InterruptedException, PathSelectionFailedException {
        return pathChooser.chooseInternalPath();
    }

    @Override
    public Circuit cannibalizeToIntroductionPoint(Router target) {
        this.cannibalizeTo(target);
        this.type = InternalType.HS_INTRODUCTION;
        return this;
    }

    private void cannibalizeTo(Router target) {
        if (this.type != InternalType.UNUSED) {
            throw new IllegalStateException("Cannot cannibalize internal circuit with type " + (Object)((Object)this.type));
        }
        CircuitExtender extender = new CircuitExtender(this, this.ntorEnabled);
        extender.extendTo(target);
    }

    @Override
    public Stream openDirectoryStream(long timeout, boolean autoclose) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        if (this.type != InternalType.HS_DIRECTORY) {
            throw new IllegalStateException("Cannot open directory stream on internal circuit with type " + (Object)((Object)this.type));
        }
        StreamImpl stream = this.createNewStream();
        try {
            stream.openDirectory(timeout);
            return stream;
        }
        catch (Exception e) {
            this.removeStream(stream);
            return this.processStreamOpenException(e);
        }
    }

    @Override
    public DirectoryCircuit cannibalizeToDirectory(Router target) {
        this.cannibalizeTo(target);
        this.type = InternalType.HS_DIRECTORY;
        return this;
    }

    @Override
    public HiddenServiceCircuit connectHiddenService(CircuitNode node) {
        if (this.type != InternalType.UNUSED) {
            throw new IllegalStateException("Cannot connect hidden service from internal circuit type " + (Object)((Object)this.type));
        }
        this.appendNode(node);
        this.type = InternalType.HS_CIRCUIT;
        return this;
    }

    @Override
    public Stream openStream(int port, long timeout) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        if (this.type != InternalType.HS_CIRCUIT) {
            throw new IllegalStateException("Cannot open stream to hidden service from internal circuit type " + (Object)((Object)this.type));
        }
        StreamImpl stream = this.createNewStream();
        try {
            stream.openExit("", port, timeout);
            return stream;
        }
        catch (Exception e) {
            this.removeStream(stream);
            return this.processStreamOpenException(e);
        }
    }

    @Override
    protected String getCircuitTypeLabel() {
        switch (this.type) {
            case HS_CIRCUIT: {
                return "Hidden Service";
            }
            case HS_DIRECTORY: {
                return "HS Directory";
            }
            case HS_INTRODUCTION: {
                return "HS Introduction";
            }
            case UNUSED: {
                return "Internal";
            }
        }
        return "(null)";
    }

    private static enum InternalType {
        UNUSED,
        HS_INTRODUCTION,
        HS_DIRECTORY,
        HS_CIRCUIT;

    }
}

