/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.CircuitExtender;
import com.subgraph.orchid.crypto.TorNTorKeyAgreement;
import java.util.logging.Logger;

public class NTorCircuitExtender {
    private static final Logger logger = Logger.getLogger(NTorCircuitExtender.class.getName());
    private final CircuitExtender extender;
    private final Router router;
    private final TorNTorKeyAgreement kex;

    public NTorCircuitExtender(CircuitExtender extender, Router router) {
        this.extender = extender;
        this.router = router;
        this.kex = new TorNTorKeyAgreement(router.getIdentityHash(), router.getNTorOnionKey());
    }

    CircuitNode extendTo() {
        byte[] onion = this.kex.createOnionSkin();
        if (this.finalRouterSupportsExtend2()) {
            logger.fine("Extending circuit to " + this.router.getNickname() + " with NTor inside RELAY_EXTEND2");
            return this.extendWithExtend2(onion);
        }
        logger.fine("Extending circuit to " + this.router.getNickname() + " with NTor inside RELAY_EXTEND");
        return this.extendWithTunneledExtend(onion);
    }

    private CircuitNode extendWithExtend2(byte[] onion) {
        RelayCell cell = this.createExtend2Cell(onion);
        this.extender.sendRelayCell(cell);
        RelayCell response = this.extender.receiveRelayResponse(15, this.router);
        return this.processExtended2(response);
    }

    private CircuitNode extendWithTunneledExtend(byte[] onion) {
        RelayCell cell = this.createExtendCell(onion, this.kex.getNtorCreateMagic());
        this.extender.sendRelayCell(cell);
        RelayCell response = this.extender.receiveRelayResponse(7, this.router);
        return this.processExtended(response);
    }

    private boolean finalRouterSupportsExtend2() {
        return this.extender.getFinalRouter().getNTorOnionKey() != null;
    }

    private RelayCell createExtend2Cell(byte[] ntorOnionskin) {
        RelayCell cell = this.extender.createRelayCell(14);
        cell.putByte(2);
        cell.putByte(0);
        cell.putByte(6);
        cell.putByteArray(this.router.getAddress().getAddressDataBytes());
        cell.putShort(this.router.getOnionPort());
        cell.putByte(2);
        cell.putByte(20);
        cell.putByteArray(this.router.getIdentityHash().getRawBytes());
        cell.putShort(2);
        cell.putShort(ntorOnionskin.length);
        cell.putByteArray(ntorOnionskin);
        return cell;
    }

    private RelayCell createExtendCell(byte[] ntorOnionskin, byte[] ntorMagic) {
        RelayCell cell = this.extender.createRelayCell(6);
        cell.putByteArray(this.router.getAddress().getAddressDataBytes());
        cell.putShort(this.router.getOnionPort());
        int paddingLength = 186 - (ntorOnionskin.length + ntorMagic.length);
        byte[] padding = new byte[paddingLength];
        cell.putByteArray(ntorMagic);
        cell.putByteArray(ntorOnionskin);
        cell.putByteArray(padding);
        cell.putByteArray(this.router.getIdentityHash().getRawBytes());
        return cell;
    }

    private CircuitNode processExtended(RelayCell cell) {
        byte[] payload = new byte[148];
        cell.getByteArray(payload);
        return this.processPayload(payload);
    }

    private CircuitNode processExtended2(RelayCell cell) {
        int payloadLength = cell.getShort();
        if (payloadLength > cell.cellBytesRemaining()) {
            throw new TorException("Incorrect payload length value in RELAY_EXTENED2 cell");
        }
        byte[] payload = new byte[payloadLength];
        cell.getByteArray(payload);
        return this.processPayload(payload);
    }

    private CircuitNode processPayload(byte[] payload) {
        byte[] keyMaterial = new byte[72];
        byte[] verifyDigest = new byte[20];
        if (!this.kex.deriveKeysFromHandshakeResponse(payload, keyMaterial, verifyDigest)) {
            return null;
        }
        return this.extender.createNewNode(this.router, keyMaterial, verifyDigest);
    }
}

