/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.TorInitializationListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TorInitializationTracker {
    private static final Logger logger = Logger.getLogger(TorInitializationTracker.class.getName());
    private static final Map<Integer, String> messageMap = new HashMap<Integer, String>();
    private final List<TorInitializationListener> listeners = new ArrayList<TorInitializationListener>();
    private final Object stateLock = new Object();
    private int bootstrapState = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TorInitializationListener listener) {
        List<TorInitializationListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TorInitializationListener listener) {
        List<TorInitializationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public int getBootstrapState() {
        return this.bootstrapState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.stateLock;
        synchronized (object) {
            this.bootstrapState = 0;
            this.notifyListeners(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(int eventCode) {
        Object object = this.stateLock;
        synchronized (object) {
            if (eventCode <= this.bootstrapState || eventCode > 100) {
                return;
            }
            this.bootstrapState = eventCode;
            this.notifyListeners(eventCode);
        }
    }

    private void notifyListeners(int code) {
        String message = this.getMessageForCode(code);
        for (TorInitializationListener listener : this.getListeners()) {
            try {
                listener.initializationProgress(message, code);
                if (code < 100) continue;
                listener.initializationCompleted();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred in TorInitializationListener callback: " + e.getMessage(), e);
            }
        }
    }

    private String getMessageForCode(int code) {
        if (messageMap.containsKey(code)) {
            return messageMap.get(code);
        }
        return "Unknown state";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TorInitializationListener> getListeners() {
        List<TorInitializationListener> list = this.listeners;
        synchronized (list) {
            return new ArrayList<TorInitializationListener>(this.listeners);
        }
    }

    static {
        messageMap.put(0, "Starting");
        messageMap.put(5, "Connecting to directory server");
        messageMap.put(10, "Finishing handshake with directory server");
        messageMap.put(15, "Establishing an encrypted directory connection");
        messageMap.put(20, "Asking for network status consensus");
        messageMap.put(25, "Loading network status consensus");
        messageMap.put(35, "Asking for authority key certs");
        messageMap.put(40, "Loading authority key certs");
        messageMap.put(45, "Asking for relay descriptors");
        messageMap.put(50, "Loading relay descriptors");
        messageMap.put(80, "Connecting to the Tor network");
        messageMap.put(85, "Finished Handshake with first hop");
        messageMap.put(90, "Establishing a Tor circuit");
        messageMap.put(100, "Done");
    }
}

