/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.HiddenServiceCircuit;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.hs.HSDescriptor;
import com.subgraph.orchid.circuits.hs.HSDescriptorCookie;
import com.subgraph.orchid.crypto.TorMessageDigest;
import com.subgraph.orchid.data.Base32;
import com.subgraph.orchid.data.HexDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HiddenService {
    private final TorConfig config;
    private final byte[] permanentId;
    private HSDescriptor descriptor;
    private HiddenServiceCircuit circuit;

    static byte[] decodeOnion(String onionAddress) {
        int idx = onionAddress.indexOf(".onion");
        if (idx == -1) {
            return Base32.base32Decode(onionAddress);
        }
        return Base32.base32Decode(onionAddress.substring(0, idx));
    }

    HiddenService(TorConfig config, byte[] permanentId) {
        this.config = config;
        this.permanentId = permanentId;
    }

    String getOnionAddressForLogging() {
        if (this.config.getSafeLogging()) {
            return "[scrubbed]";
        }
        return this.getOnionAddress();
    }

    String getOnionAddress() {
        return Base32.base32Encode(this.permanentId) + ".onion";
    }

    boolean hasCurrentDescriptor() {
        return this.descriptor != null && !this.descriptor.isExpired();
    }

    HSDescriptor getDescriptor() {
        return this.descriptor;
    }

    void setDescriptor(HSDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    HiddenServiceCircuit getCircuit() {
        return this.circuit;
    }

    void setCircuit(HiddenServiceCircuit circuit) {
        this.circuit = circuit;
    }

    HSDescriptorCookie getAuthenticationCookie() {
        return this.config.getHidServAuth(this.getOnionAddress());
    }

    List<HexDigest> getAllCurrentDescriptorIds() {
        ArrayList<HexDigest> ids = new ArrayList<HexDigest>();
        ids.add(this.getCurrentDescriptorId(0));
        ids.add(this.getCurrentDescriptorId(1));
        return ids;
    }

    HexDigest getCurrentDescriptorId(int replica) {
        TorMessageDigest digest = new TorMessageDigest();
        digest.update(this.permanentId);
        digest.update(this.getCurrentSecretId(replica));
        return digest.getHexDigest();
    }

    byte[] getCurrentSecretId(int replica) {
        TorMessageDigest digest = new TorMessageDigest();
        digest.update(this.getCurrentTimePeriod());
        HSDescriptorCookie cookie = this.getAuthenticationCookie();
        if (cookie != null && cookie.getType() == HSDescriptorCookie.CookieType.COOKIE_STEALTH) {
            digest.update(cookie.getValue());
        }
        digest.update(new byte[]{(byte)replica});
        return digest.getDigestBytes();
    }

    byte[] getCurrentTimePeriod() {
        long now = System.currentTimeMillis() / 1000L;
        int idByte = this.permanentId[0] & 0xFF;
        return HiddenService.calculateTimePeriod(now, idByte);
    }

    static byte[] calculateTimePeriod(long currentTime, int idByte) {
        long t = (currentTime + (long)idByte * 86400L / 256L) / 86400L;
        return HiddenService.toNetworkBytes(t);
    }

    static byte[] toNetworkBytes(long value) {
        byte[] result = new byte[4];
        for (int i = 3; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.permanentId);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HiddenService other = (HiddenService)obj;
        return Arrays.equals(this.permanentId, other.permanentId);
    }
}

