/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.config;

import java.util.concurrent.TimeUnit;

public class TorConfigInterval {
    private final TimeUnit timeUnit;
    private final long value;

    public static TorConfigInterval createFrom(String s) {
        String[] ss = s.split(" ");
        long n = Long.parseLong(ss[0]);
        if (ss.length == 1) {
            return new TorConfigInterval(n, TimeUnit.SECONDS);
        }
        return TorConfigInterval.createForValueAndUnit(n, ss[1]);
    }

    private static TorConfigInterval createForValueAndUnit(long value, String unitName) {
        if (TorConfigInterval.stringMatchesUnit(unitName, "week")) {
            return new TorConfigInterval(value * 7L, TimeUnit.DAYS);
        }
        TimeUnit unit = TorConfigInterval.stringToUnit(unitName);
        return new TorConfigInterval(value, unit);
    }

    private static TimeUnit stringToUnit(String s) {
        if (TorConfigInterval.stringMatchesUnit(s, "day")) {
            return TimeUnit.DAYS;
        }
        if (TorConfigInterval.stringMatchesUnit(s, "hour")) {
            return TimeUnit.HOURS;
        }
        if (TorConfigInterval.stringMatchesUnit(s, "minute")) {
            return TimeUnit.MINUTES;
        }
        if (TorConfigInterval.stringMatchesUnit(s, "second")) {
            return TimeUnit.SECONDS;
        }
        if (TorConfigInterval.stringMatchesUnit(s, "millisecond")) {
            return TimeUnit.MILLISECONDS;
        }
        throw new IllegalArgumentException();
    }

    private static boolean stringMatchesUnit(String s, String unitType) {
        if (s == null) {
            return false;
        }
        return s.equalsIgnoreCase(unitType) || s.equalsIgnoreCase(unitType + "s");
    }

    public TorConfigInterval(long value, TimeUnit timeUnit) {
        this.timeUnit = TorConfigInterval.getTimeUnitFor(value, timeUnit);
        this.value = TorConfigInterval.getValueFor(value, timeUnit);
    }

    public long getMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.value, this.timeUnit);
    }

    private static TimeUnit getTimeUnitFor(long value, TimeUnit timeUnit) {
        if (timeUnit == TimeUnit.NANOSECONDS || timeUnit == TimeUnit.MICROSECONDS) {
            return TimeUnit.MILLISECONDS;
        }
        return timeUnit;
    }

    private static long getValueFor(long value, TimeUnit timeUnit) {
        if (timeUnit == TimeUnit.NANOSECONDS || timeUnit == TimeUnit.MICROSECONDS) {
            return TimeUnit.MILLISECONDS.convert(value, timeUnit);
        }
        return value;
    }

    public String toString() {
        if (this.timeUnit == TimeUnit.DAYS && this.value % 7L == 0L) {
            long weeks = this.value / 7L;
            return weeks == 1L ? "1 week" : weeks + " weeks";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        sb.append(" ");
        sb.append(TorConfigInterval.unitToString(this.timeUnit));
        if (this.value != 1L) {
            sb.append("s");
        }
        return sb.toString();
    }

    private static String unitToString(TimeUnit unit) {
        switch (unit) {
            case MILLISECONDS: {
                return "millisecond";
            }
            case SECONDS: {
                return "second";
            }
            case MINUTES: {
                return "minute";
            }
            case HOURS: {
                return "hour";
            }
            case DAYS: {
                return "days";
            }
        }
        throw new IllegalArgumentException();
    }
}

