/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.TorException;
import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.crypto.TorMessageDigest;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.encoders.Base64;
import com.subgraph.orchid.encoders.Hex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;

public class TorSignature {
    private static final String SIGNATURE_BEGIN = "-----BEGIN SIGNATURE-----";
    private static final String ID_SIGNATURE_BEGIN = "-----BEGIN ID SIGNATURE-----";
    private static final String SIGNATURE_END = "-----END SIGNATURE-----";
    private static final String ID_SIGNATURE_END = "-----END ID SIGNATURE-----";
    private final byte[] signatureBytes;
    private final DigestAlgorithm digestAlgorithm;

    public static TorSignature createFromPEMBuffer(String buffer) {
        BufferedReader reader = new BufferedReader(new StringReader(buffer));
        String header = TorSignature.nextLine(reader);
        if (!SIGNATURE_BEGIN.equals(header) && !ID_SIGNATURE_BEGIN.equals(header)) {
            throw new TorParsingException("Did not find expected signature BEGIN header");
        }
        return new TorSignature(Base64.decode(TorSignature.parseBase64Data(reader)), DigestAlgorithm.DIGEST_SHA1);
    }

    private static String parseBase64Data(BufferedReader reader) {
        StringBuilder base64Data = new StringBuilder();
        String line;
        while (!SIGNATURE_END.equals(line = TorSignature.nextLine(reader)) && !ID_SIGNATURE_END.equals(line)) {
            base64Data.append(line);
        }
        return base64Data.toString();
    }

    static String nextLine(BufferedReader reader) {
        try {
            String line = reader.readLine();
            if (line == null) {
                throw new TorParsingException("Did not find expected signature END header");
            }
            return line;
        }
        catch (IOException e) {
            throw new TorException(e);
        }
    }

    private TorSignature(byte[] signatureBytes, DigestAlgorithm digestAlgorithm) {
        this.signatureBytes = signatureBytes;
        this.digestAlgorithm = digestAlgorithm;
    }

    public byte[] getSignatureBytes() {
        return Arrays.copyOf(this.signatureBytes, this.signatureBytes.length);
    }

    public boolean verify(TorPublicKey publicKey, TorMessageDigest digest) {
        return publicKey.verifySignature(this, digest);
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String toString() {
        return "TorSignature: (" + this.signatureBytes.length + " bytes) " + new String(Hex.encode(this.signatureBytes));
    }

    public static enum DigestAlgorithm {
        DIGEST_SHA1,
        DIGEST_SHA256;

    }
}

