/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.TorException;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class TorStreamCipher {
    public static final int KEY_LEN = 16;
    private static final int BLOCK_SIZE = 16;
    private final Cipher cipher;
    private final byte[] counter;
    private final byte[] counterOut;
    private int keystreamPointer = -1;
    private final SecretKeySpec key;

    public static TorStreamCipher createWithRandomKey() {
        SecretKey randomKey = TorStreamCipher.generateRandomKey();
        return new TorStreamCipher(randomKey.getEncoded());
    }

    public static TorStreamCipher createFromKeyBytes(byte[] keyBytes) {
        return new TorStreamCipher(keyBytes);
    }

    public static TorStreamCipher createFromKeyBytesWithIV(byte[] keyBytes, byte[] iv) {
        return new TorStreamCipher(keyBytes, iv);
    }

    private TorStreamCipher(byte[] keyBytes) {
        this(keyBytes, null);
    }

    private TorStreamCipher(byte[] keyBytes, byte[] iv) {
        this.key = TorStreamCipher.keyBytesToSecretKey(keyBytes);
        this.cipher = TorStreamCipher.createCipher(this.key);
        this.counter = new byte[16];
        this.counterOut = new byte[16];
        if (iv != null) {
            this.applyIV(iv);
        }
    }

    private void applyIV(byte[] iv) {
        if (iv.length != 16) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(iv, 0, this.counter, 0, 16);
    }

    public void encrypt(byte[] data) {
        this.encrypt(data, 0, data.length);
    }

    public synchronized void encrypt(byte[] data, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            int n = i + offset;
            data[n] = (byte)(data[n] ^ this.nextKeystreamByte());
        }
    }

    public byte[] getKeyBytes() {
        return this.key.getEncoded();
    }

    private static SecretKeySpec keyBytesToSecretKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, "AES");
    }

    private static Cipher createCipher(SecretKeySpec keySpec) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, keySpec);
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new TorException(e);
        }
    }

    private static SecretKey generateRandomKey() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(128);
            return generator.generateKey();
        }
        catch (GeneralSecurityException e) {
            throw new TorException(e);
        }
    }

    private byte nextKeystreamByte() {
        if (this.keystreamPointer == -1 || this.keystreamPointer >= 16) {
            this.updateCounter();
        }
        return this.counterOut[this.keystreamPointer++];
    }

    private void updateCounter() {
        this.encryptCounter();
        this.incrementCounter();
        this.keystreamPointer = 0;
    }

    private void encryptCounter() {
        try {
            this.cipher.doFinal(this.counter, 0, 16, this.counterOut, 0);
        }
        catch (GeneralSecurityException e) {
            throw new TorException(e);
        }
    }

    private void incrementCounter() {
        int carry = 1;
        for (int i = this.counter.length - 1; i >= 0; --i) {
            int x = (this.counter[i] & 0xFF) + carry;
            carry = x > 255 ? 1 : 0;
            this.counter[i] = (byte)x;
        }
    }
}

