/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.data.exitpolicy;

import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.exitpolicy.ExitTarget;
import com.subgraph.orchid.data.exitpolicy.PolicyRule;
import java.util.ArrayList;
import java.util.List;

public class ExitPolicy {
    private final List<PolicyRule> rules = new ArrayList<PolicyRule>();

    public void addAcceptRule(String rule) {
        this.rules.add(PolicyRule.createAcceptFromString(rule));
    }

    public void addRejectRule(String rule) {
        this.rules.add(PolicyRule.createRejectFromString(rule));
    }

    public boolean acceptsTarget(ExitTarget target) {
        if (target.isAddressTarget()) {
            return this.acceptsDestination(target.getAddress(), target.getPort());
        }
        return this.acceptsPort(target.getPort());
    }

    public boolean acceptsDestination(IPv4Address address, int port) {
        if (address == null) {
            return this.acceptsPort(port);
        }
        for (PolicyRule r : this.rules) {
            if (!r.matchesDestination(address, port)) continue;
            return r.isAcceptRule();
        }
        return true;
    }

    public boolean acceptsPort(int port) {
        for (PolicyRule r : this.rules) {
            if (!r.matchesPort(port)) continue;
            return r.isAcceptRule();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PolicyRule r : this.rules) {
            sb.append(r);
            sb.append("\n");
        }
        return sb.toString();
    }
}

