/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.data.exitpolicy;

import com.subgraph.orchid.TorException;
import com.subgraph.orchid.TorParsingException;

public class PortRange {
    private static final int MAX_PORT = 65535;
    public static final PortRange ALL_PORTS = new PortRange(1, 65535);
    private final int portStart;
    private final int portEnd;

    public static PortRange createFromString(String ports) {
        String[] parts = ports.split("-");
        if (parts.length == 1) {
            return new PortRange(PortRange.stringToPort(parts[0]));
        }
        if (parts.length == 2) {
            return new PortRange(PortRange.stringToPort(parts[0]), PortRange.stringToPort(parts[1]));
        }
        throw new TorParsingException("Could not parse port range from string: " + ports);
    }

    private static int stringToPort(String port) {
        try {
            int portValue = Integer.parseInt(port);
            if (!PortRange.isValidPort(portValue)) {
                throw new TorParsingException("Illegal port value: " + port);
            }
            return portValue;
        }
        catch (NumberFormatException e) {
            throw new TorParsingException("Could not parse port value: " + port);
        }
    }

    PortRange(int portValue) {
        this(portValue, portValue);
    }

    PortRange(int start, int end) {
        if (!PortRange.isValidRange(start, end)) {
            throw new TorException("Invalid port range: " + start + "-" + end);
        }
        this.portStart = start;
        this.portEnd = end;
    }

    private static boolean isValidRange(int start, int end) {
        if (!PortRange.isValidPort(start) || !PortRange.isValidPort(end)) {
            return false;
        }
        return start <= end;
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public boolean rangeContains(int port) {
        return port >= this.portStart && port <= this.portEnd;
    }

    public String toString() {
        if (this.portStart == 1 && this.portEnd == 65535) {
            return "*";
        }
        if (this.portStart == this.portEnd) {
            return Integer.toString(this.portStart);
        }
        return Integer.toString(this.portStart) + "-" + Integer.toString(this.portEnd);
    }
}

