/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory;

import com.subgraph.orchid.RouterStatus;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.Timestamp;
import com.subgraph.orchid.data.exitpolicy.ExitPorts;
import java.util.HashSet;
import java.util.Set;

public class DirectoryAuthorityStatus
implements RouterStatus {
    private String nickname;
    private HexDigest identity;
    private IPv4Address address;
    private int routerPort;
    private int directoryPort;
    private Set<String> flags = new HashSet<String>();
    private HexDigest v3Ident;

    void setV1Authority() {
    }

    void setHiddenServiceAuthority() {
        this.addFlag("HSDir");
    }

    void unsetHiddenServiceAuthority() {
        this.flags.remove("HSDir");
    }

    void setBridgeAuthority() {
    }

    void unsetV2Authority() {
        this.flags.remove("V2Dir");
    }

    void setNickname(String name) {
        this.nickname = name;
    }

    void setIdentity(HexDigest identity) {
        this.identity = identity;
    }

    void setAddress(IPv4Address address) {
        this.address = address;
    }

    void setRouterPort(int port) {
        this.routerPort = port;
    }

    void setDirectoryPort(int port) {
        this.directoryPort = port;
    }

    void addFlag(String flag) {
        this.flags.add(flag);
    }

    void setV3Ident(HexDigest v3Ident) {
        this.v3Ident = v3Ident;
    }

    DirectoryAuthorityStatus() {
        this.addFlag("Authority");
        this.addFlag("V2Dir");
    }

    @Override
    public IPv4Address getAddress() {
        return this.address;
    }

    @Override
    public HexDigest getDescriptorDigest() {
        return null;
    }

    @Override
    public int getDirectoryPort() {
        return this.directoryPort;
    }

    @Override
    public int getEstimatedBandwidth() {
        return 0;
    }

    @Override
    public ExitPorts getExitPorts() {
        return null;
    }

    @Override
    public HexDigest getIdentity() {
        return this.identity;
    }

    @Override
    public boolean hasBandwidth() {
        return false;
    }

    @Override
    public int getMeasuredBandwidth() {
        return 0;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public Timestamp getPublicationTime() {
        return null;
    }

    @Override
    public int getRouterPort() {
        return this.routerPort;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean hasFlag(String flag) {
        return this.flags.contains(flag);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    HexDigest getV3Ident() {
        return this.v3Ident;
    }

    @Override
    public HexDigest getMicrodescriptorDigest() {
        return null;
    }
}

