/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.consensus;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.directory.consensus.AuthoritySectionParser;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentImpl;
import com.subgraph.orchid.directory.consensus.FooterSectionParser;
import com.subgraph.orchid.directory.consensus.PreambleSectionParser;
import com.subgraph.orchid.directory.consensus.RouterStatusSectionParser;
import com.subgraph.orchid.directory.parsing.BasicDocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;
import com.subgraph.orchid.directory.parsing.DocumentParser;
import com.subgraph.orchid.directory.parsing.DocumentParsingHandler;
import com.subgraph.orchid.directory.parsing.DocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentParsingResultHandler;

public class ConsensusDocumentParser
implements DocumentParser<ConsensusDocument> {
    private static final String ITEM_DELIMITER = " ";
    private final PreambleSectionParser preambleParser;
    private final AuthoritySectionParser authorityParser;
    private final RouterStatusSectionParser routerStatusParser;
    private final FooterSectionParser footerParser;
    private final DocumentFieldParser fieldParser;
    private DocumentSection currentSection = DocumentSection.PREAMBLE;
    private final ConsensusDocumentImpl document;
    private DocumentParsingResultHandler<ConsensusDocument> resultHandler;

    public ConsensusDocumentParser(DocumentFieldParser fieldParser) {
        this.fieldParser = fieldParser;
        this.initializeParser();
        this.document = new ConsensusDocumentImpl();
        this.preambleParser = new PreambleSectionParser(fieldParser, this.document);
        this.authorityParser = new AuthoritySectionParser(fieldParser, this.document);
        this.routerStatusParser = new RouterStatusSectionParser(fieldParser, this.document);
        this.footerParser = new FooterSectionParser(fieldParser, this.document);
    }

    private void initializeParser() {
        this.fieldParser.resetRawDocument();
        this.fieldParser.setHandler(this.createParsingHandler());
        this.fieldParser.setDelimiter(ITEM_DELIMITER);
        this.fieldParser.setSignatureIgnoreToken("directory-signature");
        this.fieldParser.startSignedEntity();
    }

    @Override
    public boolean parse(DocumentParsingResultHandler<ConsensusDocument> resultHandler) {
        this.resultHandler = resultHandler;
        try {
            this.fieldParser.processDocument();
            return true;
        }
        catch (TorParsingException e) {
            resultHandler.parsingError(e.getMessage());
            return false;
        }
    }

    @Override
    public DocumentParsingResult<ConsensusDocument> parse() {
        BasicDocumentParsingResult<ConsensusDocument> result = new BasicDocumentParsingResult<ConsensusDocument>();
        this.parse((DocumentParsingResultHandler<ConsensusDocument>)result);
        return result;
    }

    private DocumentParsingHandler createParsingHandler() {
        return new DocumentParsingHandler(){

            @Override
            public void endOfDocument() {
                ConsensusDocumentParser.this.document.setRawDocumentData(ConsensusDocumentParser.this.fieldParser.getRawDocument());
                ConsensusDocumentParser.this.resultHandler.documentParsed(ConsensusDocumentParser.this.document);
                ConsensusDocumentParser.this.fieldParser.logDebug("Finished parsing status document.");
            }

            @Override
            public void parseKeywordLine() {
                ConsensusDocumentParser.this.processKeywordLine();
            }
        };
    }

    private void processKeywordLine() {
        DocumentSection newSection = null;
        while (this.currentSection != DocumentSection.NO_SECTION) {
            switch (this.currentSection) {
                case PREAMBLE: {
                    newSection = this.preambleParser.parseKeywordLine();
                    break;
                }
                case AUTHORITY: {
                    newSection = this.authorityParser.parseKeywordLine();
                    break;
                }
                case ROUTER_STATUS: {
                    newSection = this.routerStatusParser.parseKeywordLine();
                    break;
                }
                case FOOTER: {
                    newSection = this.footerParser.parseKeywordLine();
                    break;
                }
            }
            if (newSection == this.currentSection) {
                return;
            }
            this.currentSection = newSection;
        }
    }

    public static enum DocumentSection {
        NO_SECTION,
        PREAMBLE,
        AUTHORITY,
        ROUTER_STATUS,
        FOOTER;

    }
}

