/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.consensus;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentImpl;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentParser;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentSectionParser;
import com.subgraph.orchid.directory.consensus.DocumentKeyword;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;
import com.subgraph.orchid.directory.parsing.NameIntegerParameter;
import java.util.Arrays;
import java.util.List;

public class PreambleSectionParser
extends ConsensusDocumentSectionParser {
    private static final int CURRENT_DOCUMENT_VERSION = 3;
    private boolean isFirstLine = true;

    PreambleSectionParser(DocumentFieldParser parser, ConsensusDocumentImpl document) {
        super(parser, document);
    }

    @Override
    String getNextStateKeyword() {
        return "dir-source";
    }

    @Override
    ConsensusDocumentParser.DocumentSection getSection() {
        return ConsensusDocumentParser.DocumentSection.PREAMBLE;
    }

    @Override
    ConsensusDocumentParser.DocumentSection nextSection() {
        return ConsensusDocumentParser.DocumentSection.AUTHORITY;
    }

    @Override
    void parseLine(DocumentKeyword keyword) {
        if (this.isFirstLine) {
            this.parseFirstLine(keyword);
        } else {
            this.processKeyword(keyword);
        }
    }

    private void processKeyword(DocumentKeyword keyword) {
        switch (keyword) {
            case NETWORK_STATUS_VERSION: {
                throw new TorParsingException("Network status version may only appear on the first line of status document");
            }
            case VOTE_STATUS: {
                String voteStatus = this.fieldParser.parseString();
                if (voteStatus.equals("consensus")) break;
                throw new TorParsingException("Unexpected vote-status type: " + voteStatus);
            }
            case CONSENSUS_METHOD: {
                this.document.setConsensusMethod(this.fieldParser.parseInteger());
                break;
            }
            case VALID_AFTER: {
                this.document.setValidAfter(this.fieldParser.parseTimestamp());
                break;
            }
            case FRESH_UNTIL: {
                this.document.setFreshUntil(this.fieldParser.parseTimestamp());
                break;
            }
            case VALID_UNTIL: {
                this.document.setValidUntil(this.fieldParser.parseTimestamp());
                break;
            }
            case VOTING_DELAY: {
                this.document.setVoteDelaySeconds(this.fieldParser.parseInteger());
                this.document.setDistDelaySeconds(this.fieldParser.parseInteger());
                break;
            }
            case CLIENT_VERSIONS: {
                for (String version : this.parseVersions(this.fieldParser.parseString())) {
                    this.document.addClientVersion(version);
                }
                break;
            }
            case SERVER_VERSIONS: {
                for (String version : this.parseVersions(this.fieldParser.parseString())) {
                    this.document.addServerVersion(version);
                }
                break;
            }
            case KNOWN_FLAGS: {
                while (this.fieldParser.argumentsRemaining() > 0) {
                    this.document.addKnownFlag(this.fieldParser.parseString());
                }
                break;
            }
            case PARAMS: {
                this.parseParams();
                break;
            }
        }
    }

    private void parseFirstLine(DocumentKeyword keyword) {
        if (keyword != DocumentKeyword.NETWORK_STATUS_VERSION) {
            throw new TorParsingException("network-status-version not found at beginning of consensus document as expected.");
        }
        int documentVersion = this.fieldParser.parseInteger();
        if (documentVersion != 3) {
            throw new TorParsingException("Unexpected consensus document version number: " + documentVersion);
        }
        if (this.fieldParser.argumentsRemaining() > 0) {
            this.parseConsensusFlavor();
        }
        this.isFirstLine = false;
    }

    private void parseConsensusFlavor() {
        String flavor = this.fieldParser.parseString();
        if ("ns".equals(flavor)) {
            this.document.setConsensusFlavor(ConsensusDocument.ConsensusFlavor.NS);
        } else if ("microdesc".equals(flavor)) {
            this.document.setConsensusFlavor(ConsensusDocument.ConsensusFlavor.MICRODESC);
        } else {
            this.fieldParser.logWarn("Unknown consensus flavor: " + flavor);
        }
    }

    private List<String> parseVersions(String versions) {
        return Arrays.asList(versions.split(","));
    }

    private void parseParams() {
        int remaining = this.fieldParser.argumentsRemaining();
        for (int i = 0; i < remaining; ++i) {
            NameIntegerParameter p = this.fieldParser.parseParameter();
            this.document.addParameter(p.getName(), p.getValue());
        }
    }
}

