/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.geoip;

import com.subgraph.orchid.data.IPv4Address;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class CountryCodeService {
    private static final Logger logger = Logger.getLogger(CountryCodeService.class.getName());
    private static final String DATABASE_FILENAME = "GeoIP.dat";
    private static final int COUNTRY_BEGIN = 0xFFFF00;
    private static final int STANDARD_RECORD_LENGTH = 3;
    private static final int MAX_RECORD_LENGTH = 4;
    private static final CountryCodeService DEFAULT_INSTANCE = new CountryCodeService();
    private static final String[] COUNTRY_CODES = new String[]{"--", "AP", "EU", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "CW", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "SX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TL", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "RS", "ZA", "ZM", "ME", "ZW", "A1", "A2", "O1", "AX", "GG", "IM", "JE", "BL", "MF", "BQ", "SS", "O1"};
    private final byte[] database = CountryCodeService.loadDatabase();

    public static CountryCodeService getInstance() {
        return DEFAULT_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadDatabase() {
        InputStream input = CountryCodeService.openDatabaseStream();
        if (input == null) {
            logger.warning("Failed to open 'GeoIP.dat' database file for country code lookups");
            return null;
        }
        try {
            byte[] byArray = CountryCodeService.loadEntireStream(input);
            return byArray;
        }
        catch (IOException e) {
            logger.warning("IO error reading database file for country code lookups");
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static InputStream openDatabaseStream() {
        InputStream input = CountryCodeService.tryResourceOpen();
        if (input != null) {
            return input;
        }
        return CountryCodeService.tryFilesystemOpen();
    }

    private static InputStream tryFilesystemOpen() {
        File dataDir = new File(System.getProperty("user.dir"), "data");
        File dbFile = new File(dataDir, DATABASE_FILENAME);
        if (!dbFile.canRead()) {
            return null;
        }
        try {
            return new FileInputStream(dbFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private static InputStream tryResourceOpen() {
        return CountryCodeService.class.getResourceAsStream("/data/GeoIP.dat");
    }

    private static byte[] loadEntireStream(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        CountryCodeService.copy(input, output);
        return output.toByteArray();
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public String getCountryCodeForAddress(IPv4Address address) {
        return COUNTRY_CODES[this.seekCountry(address)];
    }

    private int seekCountry(IPv4Address address) {
        if (this.database == null) {
            return 0;
        }
        byte[] record = new byte[8];
        int[] x = new int[2];
        long ip = (long)address.getAddressData() & 0xFFFFFFFFL;
        int offset = 0;
        for (int depth = 31; depth >= 0; --depth) {
            int xx;
            this.loadRecord(offset, record);
            x[0] = this.unpackRecordValue(record, 0);
            x[1] = this.unpackRecordValue(record, 1);
            int n = xx = (ip & (long)(1 << depth)) > 0L ? x[1] : x[0];
            if (xx >= 0xFFFF00) {
                int idx = xx - 0xFFFF00;
                if (idx < 0 || idx > COUNTRY_CODES.length) {
                    logger.warning("Invalid index calculated looking up country code record for (" + address + ") idx = " + idx);
                    return 0;
                }
                return idx;
            }
            offset = xx;
        }
        logger.warning("No record found looking up country code record for (" + address + ")");
        return 0;
    }

    private void loadRecord(int offset, byte[] recordBuffer) {
        int dbOffset = 6 * offset;
        System.arraycopy(this.database, dbOffset, recordBuffer, 0, recordBuffer.length);
    }

    private int unpackRecordValue(byte[] record, int idx) {
        int valueOffset = idx * 3;
        int value = 0;
        for (int i = 0; i < 3; ++i) {
            int octet = record[valueOffset + i] & 0xFF;
            value += octet << i * 8;
        }
        return value;
    }
}

