/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.socks;

import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.socks.SocksRequestException;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Logger;

public abstract class SocksRequest {
    private static final Logger logger = Logger.getLogger(SocksRequest.class.getName());
    private final TorConfig config;
    private final Socket socket;
    private byte[] addressData;
    private IPv4Address address;
    private String hostname;
    private int port;
    private long lastWarningTimestamp = 0L;

    protected SocksRequest(TorConfig config, Socket socket) {
        this.config = config;
        this.socket = socket;
    }

    public abstract void readRequest() throws SocksRequestException;

    public abstract int getCommandCode();

    public abstract boolean isConnectRequest();

    abstract void sendError(boolean var1) throws SocksRequestException;

    abstract void sendSuccess() throws SocksRequestException;

    abstract void sendConnectionRefused() throws SocksRequestException;

    public int getPort() {
        return this.port;
    }

    public IPv4Address getAddress() {
        return this.address;
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getTarget() {
        if (this.config.getSafeLogging()) {
            return "[scrubbed]:" + this.port;
        }
        if (this.hostname != null) {
            return this.hostname + ":" + this.port;
        }
        return this.address + ":" + this.port;
    }

    protected void setPortData(byte[] data) throws SocksRequestException {
        if (data.length != 2) {
            throw new SocksRequestException();
        }
        this.port = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
    }

    protected void setIPv4AddressData(byte[] data) throws SocksRequestException {
        this.logUnsafeSOCKS();
        if (data.length != 4) {
            throw new SocksRequestException();
        }
        this.addressData = data;
        int addressValue = 0;
        for (byte b : this.addressData) {
            addressValue <<= 8;
            addressValue |= b & 0xFF;
        }
        this.address = new IPv4Address(addressValue);
    }

    private boolean testRateLimit() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastWarningTimestamp;
        this.lastWarningTimestamp = now;
        return diff > 5000L;
    }

    private void logUnsafeSOCKS() throws SocksRequestException {
        if ((this.config.getWarnUnsafeSocks() || this.config.getSafeSocks()) && this.testRateLimit()) {
            logger.warning("Your application is giving Orchid only an IP address.  Applications that do DNS resolves themselves may leak information. Consider using Socks4a (e.g. via privoxy or socat) instead.  For more information please see https://wiki.torproject.org/TheOnionRouter/TorFAQ#SOCKSAndDNS");
        }
        if (this.config.getSafeSocks()) {
            throw new SocksRequestException("Rejecting unsafe SOCKS request");
        }
    }

    protected void setHostname(String name) {
        this.hostname = name;
    }

    protected byte[] readPortData() throws SocksRequestException {
        byte[] data = new byte[2];
        this.readAll(data, 0, 2);
        return data;
    }

    protected byte[] readIPv4AddressData() throws SocksRequestException {
        byte[] data = new byte[4];
        this.readAll(data);
        return data;
    }

    protected byte[] readIPv6AddressData() throws SocksRequestException {
        byte[] data = new byte[16];
        this.readAll(data);
        return data;
    }

    protected String readNullTerminatedString() throws SocksRequestException {
        try {
            StringBuilder sb = new StringBuilder();
            while (true) {
                int c;
                if ((c = this.socket.getInputStream().read()) == -1) {
                    throw new SocksRequestException();
                }
                if (c == 0) {
                    return sb.toString();
                }
                char ch = (char)c;
                sb.append(ch);
            }
        }
        catch (IOException e) {
            throw new SocksRequestException(e);
        }
    }

    protected int readByte() throws SocksRequestException {
        try {
            int n = this.socket.getInputStream().read();
            if (n == -1) {
                throw new SocksRequestException();
            }
            return n;
        }
        catch (IOException e) {
            throw new SocksRequestException(e);
        }
    }

    protected void readAll(byte[] buffer) throws SocksRequestException {
        this.readAll(buffer, 0, buffer.length);
    }

    protected void readAll(byte[] buffer, int offset, int length) throws SocksRequestException {
        try {
            while (length > 0) {
                int n = this.socket.getInputStream().read(buffer, offset, length);
                if (n == -1) {
                    throw new SocksRequestException();
                }
                offset += n;
                length -= n;
            }
        }
        catch (IOException e) {
            throw new SocksRequestException(e);
        }
    }

    protected void socketWrite(byte[] buffer) throws SocksRequestException {
        try {
            this.socket.getOutputStream().write(buffer);
        }
        catch (IOException e) {
            throw new SocksRequestException(e);
        }
    }
}

