/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.socks;

import com.subgraph.orchid.Stream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Logger;

public class SocksStreamConnection {
    private static final Logger logger = Logger.getLogger(SocksStreamConnection.class.getName());
    private static final int TRANSFER_BUFFER_SIZE = 4096;
    private final Stream stream;
    private final InputStream torInputStream;
    private final OutputStream torOutputStream;
    private final Socket socket;
    private final Thread incomingThread;
    private final Thread outgoingThread;
    private final Object lock = new Object();
    private volatile boolean outgoingClosed;
    private volatile boolean incomingClosed;

    public static void runConnection(Socket socket, Stream stream) {
        SocksStreamConnection ssc = new SocksStreamConnection(socket, stream);
        ssc.run();
    }

    private SocksStreamConnection(Socket socket, Stream stream) {
        this.socket = socket;
        this.stream = stream;
        this.torInputStream = stream.getInputStream();
        this.torOutputStream = stream.getOutputStream();
        this.incomingThread = this.createIncomingThread();
        this.outgoingThread = this.createOutgoingThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.incomingThread.start();
        this.outgoingThread.start();
        Object object = this.lock;
        synchronized (object) {
            while (!this.outgoingClosed || !this.incomingClosed) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                logger.warning("IOException on SOCKS socket close(): " + e.getMessage());
            }
            this.closeStream(this.torInputStream);
            this.closeStream(this.torOutputStream);
        }
    }

    private Thread createIncomingThread() {
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SocksStreamConnection.this.incomingTransferLoop();
                }
                catch (IOException e) {
                    logger.fine("System error on incoming stream IO  " + SocksStreamConnection.this.stream + " : " + e.getMessage());
                }
                finally {
                    Object object = SocksStreamConnection.this.lock;
                    synchronized (object) {
                        SocksStreamConnection.this.incomingClosed = true;
                        SocksStreamConnection.this.lock.notifyAll();
                    }
                }
            }
        });
    }

    private Thread createOutgoingThread() {
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SocksStreamConnection.this.outgoingTransferLoop();
                }
                catch (IOException e) {
                    logger.fine("System error on outgoing stream IO " + SocksStreamConnection.this.stream + " : " + e.getMessage());
                }
                finally {
                    Object object = SocksStreamConnection.this.lock;
                    synchronized (object) {
                        SocksStreamConnection.this.outgoingClosed = true;
                        SocksStreamConnection.this.lock.notifyAll();
                    }
                }
            }
        });
    }

    private void incomingTransferLoop() throws IOException {
        byte[] incomingBuffer = new byte[4096];
        while (true) {
            int n;
            if ((n = this.torInputStream.read(incomingBuffer)) == -1) {
                logger.fine("EOF on TOR input stream " + this.stream);
                this.socket.shutdownOutput();
                return;
            }
            if (n <= 0) continue;
            logger.fine("Transferring " + n + " bytes from " + this.stream + " to SOCKS socket");
            if (this.socket.isOutputShutdown()) break;
            this.socket.getOutputStream().write(incomingBuffer, 0, n);
            this.socket.getOutputStream().flush();
        }
        this.closeStream(this.torInputStream);
    }

    private void outgoingTransferLoop() throws IOException {
        byte[] outgoingBuffer = new byte[4096];
        while (true) {
            this.stream.waitForSendWindow();
            int n = this.socket.getInputStream().read(outgoingBuffer);
            if (n == -1) {
                this.torOutputStream.close();
                logger.fine("EOF on SOCKS socket connected to " + this.stream);
                return;
            }
            if (n <= 0) continue;
            logger.fine("Transferring " + n + " bytes from SOCKS socket to " + this.stream);
            this.torOutputStream.write(outgoingBuffer, 0, n);
            this.torOutputStream.flush();
        }
    }

    private void closeStream(Closeable c) {
        try {
            c.close();
        }
        catch (IOException e) {
            logger.warning("Close failed on " + c + " : " + e.getMessage());
        }
    }
}

