/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.connectors.cmis.cmisclient.AtompubCMISClient;
import org.bonitasoft.connectors.cmis.cmisclient.CMISParametersValidator;
import org.bonitasoft.connectors.cmis.cmisclient.WebserviceCMISClient;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public abstract class AbstractCMISConnector
extends AbstractConnector {
    public static final String ATOMPUB = "atompub";
    public static final String WEBSERVICE = "webservices";
    public static final String URL = "url";
    public static final String REPOSITORY = "repository";
    public static final String BINDING = "binding_type";
    public static final String WEBSERVICES_OBJECT_SERVICE = "wsObjectServiceUrl";
    public static final String WEBSERVICES_OBJECT_SERVICE_ENDPOINT = "wsObjectServiceEndpointUrl";
    public static final String WEBSERVICES_REPOSITORY_SERVICE = "wsRepositoryServiceUrl";
    public static final String WEBSERVICES_REPOSITORY_SERVICE_ENDPOINT = "wsRepositoryServiceEndpointUrl";
    public static final String WEBSERVICES_VERSIONING_SERVICE = "wsVersioningServiceUrl";
    public static final String WEBSERVICES_VERSIONING_SERVICE_ENDPOINT = "wsVersioningServiceEndpointUrl";
    public static final String WEBSERVICES_NAVIGATION_SERVICE = "wsNavigationServiceUrl";
    public static final String WEBSERVICES_NAVIGATION_SERVICE_ENDPOINT = "wsNavigationServiceEndpointUrl";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private String url;
    private String bindingType;
    private String username;
    private String password;
    private String repository;
    private Map<String, String> serviceBinding;
    private Map<String, Object> inputParameters;
    private AbstractCmisClient cmisClient;

    public void connect() throws ConnectorException {
        super.connect();
        if (ATOMPUB.equals(this.bindingType)) {
            this.cmisClient = new AtompubCMISClient(this.username, this.password, this.repository, this.url);
        } else if (WEBSERVICE.equals(this.bindingType)) {
            this.cmisClient = new WebserviceCMISClient(this.username, this.password, this.repository, this.serviceBinding);
        } else {
            throw new IllegalArgumentException("Invalid binding type : " + this.bindingType);
        }
        this.cmisClient.connect();
    }

    public void disconnect() throws ConnectorException {
        super.disconnect();
        if (this.cmisClient != null) {
            this.cmisClient.disconnect();
            this.cmisClient = null;
        }
    }

    protected AbstractCmisClient getClient() {
        return this.cmisClient;
    }

    protected Map<String, Object> getInputParameters() {
        return this.inputParameters;
    }

    public void validateInputParameters() throws ConnectorValidationException {
        ArrayList<String> messages = new ArrayList<String>(0);
        CMISParametersValidator cmisParametersValidator = new CMISParametersValidator(this.inputParameters);
        messages.addAll(cmisParametersValidator.validateCommonParameters());
        messages.addAll(cmisParametersValidator.validateSpecificParameters());
        if (!messages.isEmpty()) {
            throw new ConnectorValidationException((Connector)this, messages);
        }
    }

    public void setInputParameters(Map<String, Object> parameters) {
        String versioningServiceEndpoint;
        String versioningServiceUrl;
        String repoServiceEndpoint;
        String repoServiceUrl;
        String objectServiceEndpoint;
        this.inputParameters = parameters;
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().toString());
        this.url = (String)parameters.get(URL);
        logger.log(Level.ALL, this.url);
        this.bindingType = (String)parameters.get(BINDING);
        logger.log(Level.ALL, BINDING);
        this.username = (String)parameters.get(USERNAME);
        logger.log(Level.ALL, USERNAME);
        this.password = (String)parameters.get(PASSWORD);
        logger.log(Level.ALL, PASSWORD);
        this.repository = (String)parameters.get(REPOSITORY);
        logger.log(Level.ALL, REPOSITORY);
        this.serviceBinding = new HashMap<String, String>();
        String objectServiceUrl = (String)parameters.get(WEBSERVICES_OBJECT_SERVICE);
        if (objectServiceUrl != null && !objectServiceUrl.isEmpty()) {
            this.serviceBinding.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", objectServiceUrl);
        }
        if ((objectServiceEndpoint = (String)parameters.get(WEBSERVICES_OBJECT_SERVICE_ENDPOINT)) != null && !objectServiceEndpoint.isEmpty()) {
            this.serviceBinding.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService.endpoint", objectServiceEndpoint);
        }
        if ((repoServiceUrl = (String)parameters.get(WEBSERVICES_REPOSITORY_SERVICE)) != null && !repoServiceUrl.isEmpty()) {
            this.serviceBinding.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", repoServiceUrl);
        }
        if ((repoServiceEndpoint = (String)parameters.get(WEBSERVICES_OBJECT_SERVICE_ENDPOINT)) != null && !repoServiceEndpoint.isEmpty()) {
            this.serviceBinding.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService.endpoint", repoServiceEndpoint);
        }
        if ((versioningServiceUrl = (String)parameters.get(WEBSERVICES_VERSIONING_SERVICE)) != null && !versioningServiceUrl.isEmpty()) {
            this.serviceBinding.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", versioningServiceUrl);
        }
        if ((versioningServiceEndpoint = (String)parameters.get(WEBSERVICES_VERSIONING_SERVICE_ENDPOINT)) != null && !versioningServiceEndpoint.isEmpty()) {
            this.serviceBinding.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService.endpoint", versioningServiceEndpoint);
        }
    }
}

