/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.util.Map;
import org.bonitasoft.connectors.cmis.AbstractCMISConnector;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.engine.connector.ConnectorException;

public class DeleteFolder
extends AbstractCMISConnector {
    public static final String FOLDER_PATH = "folder_path";
    public static final String IS_FOLDER_DELETED_OUTPUT = "isFolderDeleted";
    private String folderPath;

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        super.setInputParameters(parameters);
        this.folderPath = (String)parameters.get(FOLDER_PATH);
    }

    protected void executeBusinessLogic() throws ConnectorException {
        AbstractCmisClient cmisClient = this.getClient();
        if (cmisClient == null) {
            throw new ConnectorException("CMIS DeleteFolder connector is not connected properly.");
        }
        if (!cmisClient.checkIfObjectExists(this.folderPath).booleanValue()) {
            throw new ConnectorException("Folder " + this.folderPath + " does not exist!");
        }
        try {
            cmisClient.deleteFolderByPath(this.folderPath);
            this.setOutputParameter(IS_FOLDER_DELETED_OUTPUT, cmisClient.checkIfObjectExists(this.folderPath) == false);
        }
        catch (Throwable throwable) {
            this.setOutputParameter(IS_FOLDER_DELETED_OUTPUT, cmisClient.checkIfObjectExists(this.folderPath) == false);
            throw throwable;
        }
    }
}

