/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.bonitasoft.connectors.cmis.AbstractCMISConnector;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.bonitasoft.engine.io.IOUtil;

public class DownloadDocument
extends AbstractCMISConnector {
    public static final String DOCUMENT_OUTPUT = "documentOutput";
    public static final String REMOTE_DOCUMENT_PATH = "remote_document_path";
    private String remote_path;

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        super.setInputParameters(parameters);
        this.remote_path = (String)parameters.get(REMOTE_DOCUMENT_PATH);
    }

    protected void executeBusinessLogic() throws ConnectorException {
        DocumentValue docValue;
        AbstractCmisClient cmisClient = this.getClient();
        if (cmisClient == null) {
            throw new ConnectorException("CMIS DownloadDocument connector is not connected properly.");
        }
        if (!cmisClient.checkIfObjectExists(this.remote_path).booleanValue()) {
            throw new ConnectorException("Document " + this.remote_path + " does not exists!");
        }
        Document cmisDocument = (Document)cmisClient.getObjectByPath(this.remote_path);
        ContentStream contentStream = cmisDocument.getContentStream();
        try {
            docValue = new DocumentValue(IOUtil.getAllContentFrom((InputStream)contentStream.getStream()), contentStream.getMimeType(), contentStream.getFileName());
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
        this.setOutputParameter(DOCUMENT_OUTPUT, docValue);
    }

    @Override
    public void validateInputParameters() throws ConnectorValidationException {
        super.validateInputParameters();
        try {
            this.getInputParameter(REMOTE_DOCUMENT_PATH);
        }
        catch (ClassCastException ex) {
            throw new ConnectorValidationException("Invalid type for input remote_document_path");
        }
    }
}

