/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.database.datasource;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.bonitasoft.connectors.database.Database;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public class DatasourceConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(DatasourceConnector.class.getName());
    public static final String DATASOURCE_INPUT = "dataSourceName";
    public static final String SCRIPT_INPUT = "script";
    public static final String SEPARATOR_INPUT = "separator";
    public static final String PROPERTIES_INPUT = "properties";
    private String datasource;
    private String script;
    private String separator;
    private Properties properties;
    private Database database;

    public Map<String, Object> execute() throws ConnectorException {
        if (this.hasMultipleQuery()) {
            return this.executeBatch();
        }
        return this.executeSingleQuery();
    }

    private boolean hasMultipleQuery() {
        return this.separator != null;
    }

    public void setInputParameters(Map<String, Object> parameters) {
        this.datasource = (String)parameters.get(DATASOURCE_INPUT);
        LOGGER.info("dataSourceName " + this.datasource);
        this.script = (String)parameters.get(SCRIPT_INPUT);
        LOGGER.info("script " + this.script);
        this.separator = (String)parameters.get(SEPARATOR_INPUT);
        LOGGER.info("separator " + this.separator);
        List propertiesList = (List)parameters.get(PROPERTIES_INPUT);
        if (propertiesList != null) {
            this.properties = new Properties();
            for (List line : propertiesList) {
                if (line.size() == 1) {
                    LOGGER.info("Property " + line.get(0) + " null");
                    this.properties.put(line.get(0), (Object)null);
                    continue;
                }
                if (line.size() != 2) continue;
                LOGGER.info("Property " + line.get(0) + " " + line.get(1));
                this.properties.put(line.get(0), line.get(1));
            }
        }
    }

    public void validateInputParameters() throws ConnectorValidationException {
        ArrayList<String> messages = new ArrayList<String>(0);
        if (this.datasource == null || this.datasource.isEmpty()) {
            messages.add("Datasource can't be empty");
        }
        if (this.script == null || this.script.isEmpty()) {
            messages.add("Script is not set");
        }
        if (!messages.isEmpty()) {
            throw new ConnectorValidationException((Connector)this, messages);
        }
    }

    public void connect() throws ConnectorException {
        try {
            this.database = new Database(this.datasource, this.properties);
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void disconnect() throws ConnectorException {
        if (this.database != null) {
            try {
                this.database.disconnect();
            }
            catch (Exception e) {
                throw new ConnectorException((Throwable)e);
            }
        }
    }

    private Map<String, Object> executeSingleQuery() throws ConnectorException {
        try {
            String command = this.script.toUpperCase().trim();
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            if (command.startsWith("SELECT")) {
                result.put("resultset", this.database.select(this.script));
            } else {
                this.database.executeCommand(this.script);
            }
            return result;
        }
        catch (SQLException sqle) {
            throw new ConnectorException((Throwable)sqle);
        }
    }

    private Map<String, Object> executeBatch() throws ConnectorException {
        List<String> commands = this.getScriptCommands();
        try {
            this.database.executeBatch(commands, true);
            return null;
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private List<String> getScriptCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.script, this.separator);
        while (tokenizer.hasMoreTokens()) {
            String command = tokenizer.nextToken();
            commands.add(command.trim());
        }
        return commands;
    }
}

